/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.structure.buffer.items;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.math.vector.Location;
import com.dfsek.terra.api.platform.block.Block;
import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.platform.block.data.Waterlogged;
import com.dfsek.terra.api.structures.structure.buffer.items.BufferedItem;

public class BufferedBlock
implements BufferedItem {
    private final BlockData data;
    private final boolean overwrite;
    private final TerraPlugin main;
    private final boolean waterlog;

    public BufferedBlock(BlockData data, boolean overwrite, TerraPlugin main, boolean waterlog) {
        this.data = data;
        this.overwrite = overwrite;
        this.main = main;
        this.waterlog = waterlog;
    }

    @Override
    public void paste(Location origin) {
        Block block = origin.getBlock();
        try {
            if (this.overwrite || block.isEmpty()) {
                if (this.waterlog && this.data instanceof Waterlogged && block.getBlockData().getBlockType().isWater()) {
                    ((Waterlogged)this.data).setWaterlogged(true);
                }
                block.setBlockData(this.data, false);
            }
        }
        catch (RuntimeException e) {
            this.main.logger().severe("Failed to place block at location " + origin + ": " + e.getMessage());
            this.main.getDebugLogger().stack(e);
        }
    }
}

