/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.tokenizer;

public class Char {
    private final char character;
    private final int index;
    private final int line;

    public Char(char character, int index, int line) {
        this.character = character;
        this.index = index;
        this.line = line;
    }

    public char getCharacter() {
        return this.character;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }

    public boolean isWhitespace() {
        return Character.isWhitespace(this.character);
    }

    public boolean isNewLine() {
        return this.character == '\n';
    }

    public boolean isDigit() {
        return Character.isDigit(this.character);
    }

    public boolean is(char ... tests) {
        for (char test : tests) {
            if (test != this.character || test == '\u0000') continue;
            return true;
        }
        return false;
    }

    public boolean isEOF() {
        return this.character == '\u0000';
    }

    public String toString() {
        return Character.toString(this.character);
    }
}

