/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.structures.tokenizer;

import com.dfsek.terra.api.structures.tokenizer.Position;

public class Token {
    private final String content;
    private final Type type;
    private final Position start;

    public Token(String content, Type type, Position start) {
        this.content = content;
        this.type = type;
        this.start = start;
    }

    public Type getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public Position getPosition() {
        return this.start;
    }

    public String toString() {
        return (Object)((Object)this.type) + ": '" + this.content + "'";
    }

    public boolean isConstant() {
        return this.type.equals((Object)Type.NUMBER) || this.type.equals((Object)Type.STRING) || this.type.equals((Object)Type.BOOLEAN);
    }

    public boolean isBinaryOperator() {
        return this.type.equals((Object)Type.ADDITION_OPERATOR) || this.type.equals((Object)Type.SUBTRACTION_OPERATOR) || this.type.equals((Object)Type.MULTIPLICATION_OPERATOR) || this.type.equals((Object)Type.DIVISION_OPERATOR) || this.type.equals((Object)Type.EQUALS_OPERATOR) || this.type.equals((Object)Type.NOT_EQUALS_OPERATOR) || this.type.equals((Object)Type.LESS_THAN_OPERATOR) || this.type.equals((Object)Type.GREATER_THAN_OPERATOR) || this.type.equals((Object)Type.LESS_THAN_OR_EQUALS_OPERATOR) || this.type.equals((Object)Type.GREATER_THAN_OR_EQUALS_OPERATOR) || this.type.equals((Object)Type.BOOLEAN_OR) || this.type.equals((Object)Type.BOOLEAN_AND) || this.type.equals((Object)Type.MODULO_OPERATOR);
    }

    public boolean isStrictNumericOperator() {
        return this.type.equals((Object)Type.SUBTRACTION_OPERATOR) || this.type.equals((Object)Type.MULTIPLICATION_OPERATOR) || this.type.equals((Object)Type.DIVISION_OPERATOR) || this.type.equals((Object)Type.GREATER_THAN_OPERATOR) || this.type.equals((Object)Type.LESS_THAN_OPERATOR) || this.type.equals((Object)Type.LESS_THAN_OR_EQUALS_OPERATOR) || this.type.equals((Object)Type.GREATER_THAN_OR_EQUALS_OPERATOR) || this.type.equals((Object)Type.MODULO_OPERATOR);
    }

    public boolean isStrictBooleanOperator() {
        return this.type.equals((Object)Type.BOOLEAN_AND) || this.type.equals((Object)Type.BOOLEAN_OR);
    }

    public boolean isVariableDeclaration() {
        return this.type.equals((Object)Type.STRING_VARIABLE) || this.type.equals((Object)Type.BOOLEAN_VARIABLE) || this.type.equals((Object)Type.NUMBER_VARIABLE);
    }

    public boolean isLoopLike() {
        return this.type.equals((Object)Type.IF_STATEMENT) || this.type.equals((Object)Type.WHILE_LOOP) || this.type.equals((Object)Type.FOR_LOOP);
    }

    public boolean isIdentifier() {
        return this.type.equals((Object)Type.IDENTIFIER);
    }

    public static enum Type {
        IDENTIFIER,
        NUMBER,
        STRING,
        BOOLEAN,
        GROUP_BEGIN,
        GROUP_END,
        STATEMENT_END,
        SEPARATOR,
        BLOCK_BEGIN,
        BLOCK_END,
        ASSIGNMENT,
        EQUALS_OPERATOR,
        NOT_EQUALS_OPERATOR,
        GREATER_THAN_OPERATOR,
        LESS_THAN_OPERATOR,
        GREATER_THAN_OR_EQUALS_OPERATOR,
        LESS_THAN_OR_EQUALS_OPERATOR,
        ADDITION_OPERATOR,
        SUBTRACTION_OPERATOR,
        MULTIPLICATION_OPERATOR,
        DIVISION_OPERATOR,
        MODULO_OPERATOR,
        BOOLEAN_NOT,
        BOOLEAN_OR,
        BOOLEAN_AND,
        NUMBER_VARIABLE,
        STRING_VARIABLE,
        BOOLEAN_VARIABLE,
        IF_STATEMENT,
        WHILE_LOOP,
        RETURN,
        CONTINUE,
        BREAK,
        FAIL,
        ID,
        FOR_LOOP,
        ELSE;

    }
}

