/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.transform;

import com.dfsek.terra.api.transform.AttemptsFailedException;
import com.dfsek.terra.api.transform.Transform;
import com.dfsek.terra.api.transform.TransformException;
import com.dfsek.terra.api.transform.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Transformer<F, T> {
    private final LinkedHashMap<Transform<F, T>, List<Validator<T>>> transformers;

    private Transformer(LinkedHashMap<Transform<F, T>, List<Validator<T>>> transformer) {
        this.transformers = transformer;
    }

    public T translate(F from) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (Map.Entry<Transform<F, T>, List<Validator<T>>> transform : this.transformers.entrySet()) {
            try {
                T result = transform.getKey().transform(from);
                for (Validator<T> validator : transform.getValue()) {
                    if (validator.validate(result)) continue;
                    throw new TransformException("Failed to validate result: " + result.toString());
                }
                return result;
            }
            catch (Exception exception) {
                exceptions.add(exception);
            }
        }
        throw new AttemptsFailedException("Could not transform input; all attempts failed: " + from.toString() + "\n", exceptions);
    }

    public static final class Builder<F, T> {
        private final LinkedHashMap<Transform<F, T>, List<Validator<T>>> transforms = new LinkedHashMap();

        @SafeVarargs
        public final Builder<F, T> addTransform(Transform<F, T> transform, Validator<T> ... validators) {
            this.transforms.put(transform, Arrays.asList(validators));
            return this;
        }

        public Transformer<F, T> build() {
            return new Transformer(this.transforms);
        }
    }
}

