/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.util;

import com.dfsek.terra.lib.jafama.FastMath;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class GlueList<T>
extends AbstractList<T>
implements List<T>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -4339173882660322249L;
    private transient Node<T> first;
    private transient Node<T> last;
    private int size;
    private int initialCapacity;
    private static final int DEFAULT_CAPACITY = 10;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public GlueList() {
        Node initNode = new Node(null, null, 0, 10);
        this.first = initNode;
        this.last = initNode;
    }

    public GlueList(int initialCapacity) {
        this.initialCapacity = initialCapacity > 0x7FFFFFF7 ? 0x7FFFFFF7 : initialCapacity;
        Node initNode = new Node(null, null, 0, initialCapacity);
        this.first = initNode;
        this.last = initNode;
    }

    public GlueList(Collection<? extends T> c) {
        Objects.requireNonNull(c);
        Object[] arr = c.toArray();
        int len = arr.length;
        if (len != 0) {
            Node initNode = new Node(null, null, 0, len);
            this.first = initNode;
            this.last = initNode;
            System.arraycopy(arr, 0, this.last.elementData, 0, len);
            this.last.elementDataPointer += len;
        } else {
            Node initNode = new Node(null, null, 0, 10);
            this.first = initNode;
            this.last = initNode;
        }
        ++this.modCount;
        this.size += len;
    }

    @Override
    public boolean add(T element) {
        Node<T> l = this.last;
        if (l.isAddable()) {
            l.add(element);
        } else {
            Node<T> newNode = new Node<T>(l, null, this.size);
            newNode.add(element);
            this.last = newNode;
            l.next = this.last;
        }
        ++this.modCount;
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, T element) {
        this.rangeCheckForAdd(index);
        Node<T> node = this.getNodeForAdd(index);
        if (node == null) {
            Node<T> l = this.last;
            Node<T> newNode = new Node<T>(l, null, this.size);
            this.last = newNode;
            l.next = this.last;
            node = newNode;
        }
        if (node == this.last && node.elementData.length - node.elementDataPointer > 0) {
            int nodeArrIndex = index - node.startingIndex;
            System.arraycopy(node.elementData, nodeArrIndex, node.elementData, nodeArrIndex + 1, node.elementDataPointer - nodeArrIndex);
            node.elementData[nodeArrIndex] = element;
            if (nodeArrIndex > 0) {
                System.arraycopy(node.elementData, 0, node.elementData, 0, nodeArrIndex);
            }
            ++node.elementDataPointer;
        } else {
            int newLen = node.elementData.length + 1;
            Object[] newElementData = new Object[newLen];
            int nodeArrIndex = index - node.startingIndex;
            System.arraycopy(node.elementData, nodeArrIndex, newElementData, nodeArrIndex + 1, node.elementDataPointer - nodeArrIndex);
            newElementData[nodeArrIndex] = element;
            if (nodeArrIndex > 0) {
                System.arraycopy(node.elementData, 0, newElementData, 0, nodeArrIndex);
            }
            node.elementData = newElementData;
            ++node.endingIndex;
            ++node.elementDataPointer;
        }
        this.updateNodesAfterAdd(node);
        ++this.modCount;
        ++this.size;
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    private void updateNodesAfterAdd(Node<T> nodeFrom) {
        Node node = nodeFrom.next;
        while (node != null) {
            ++node.startingIndex;
            ++node.endingIndex;
            node = node.next;
        }
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        Objects.requireNonNull(c);
        Object[] collection = c.toArray();
        int len = collection.length;
        if (len == 0) {
            return false;
        }
        if (this.size == 0) {
            if (this.initialCapacity >= len) {
                System.arraycopy(collection, 0, this.last.elementData, 0, len);
            } else {
                this.last.elementData = Arrays.copyOf(collection, len);
                this.last.endingIndex = len - 1;
            }
            this.last.elementDataPointer += len;
            ++this.modCount;
            this.size += len;
            return true;
        }
        int elementDataLen = this.last.elementData.length;
        int elementSize = this.last.elementDataPointer;
        int remainedStorage = elementDataLen - elementSize;
        if (remainedStorage == 0) {
            Node<T> l = this.last;
            int newLen = this.size >>> 1;
            int initialLen = len > newLen ? len : newLen;
            Node<T> newNode = new Node<T>(l, null, this.size, initialLen);
            System.arraycopy(collection, 0, newNode.elementData, 0, len);
            newNode.elementDataPointer += len;
            this.last = newNode;
            l.next = this.last;
            ++this.modCount;
            this.size += len;
            return true;
        }
        if (len <= remainedStorage) {
            System.arraycopy(collection, 0, this.last.elementData, elementSize, len);
            this.last.elementDataPointer += len;
            ++this.modCount;
            this.size += len;
            return true;
        }
        if (len > remainedStorage) {
            System.arraycopy(collection, 0, this.last.elementData, elementSize, remainedStorage);
            this.last.elementDataPointer += remainedStorage;
            this.size += remainedStorage;
            int newLen = this.size >>> 1;
            int remainedDataLen = len - remainedStorage;
            int initialLen = newLen > remainedDataLen ? newLen : remainedDataLen;
            Node<T> l = this.last;
            Node<T> newNode = new Node<T>(l, null, this.size, initialLen);
            System.arraycopy(collection, remainedStorage, newNode.elementData, 0, remainedDataLen);
            newNode.elementDataPointer += remainedDataLen;
            this.last = newNode;
            l.next = this.last;
            ++this.modCount;
            this.size += remainedDataLen;
            return true;
        }
        return false;
    }

    @Override
    public T set(int index, T element) {
        this.rangeCheck(index);
        Node<T> node = this.getNode(index);
        int nodeArrIndex = index - node.startingIndex;
        Object oldValue = node.elementData[nodeArrIndex];
        node.elementData[nodeArrIndex] = element;
        return oldValue;
    }

    @Override
    public T get(int index) {
        this.rangeCheck(index);
        Node<T> node = this.getNode(index);
        return node.elementData[index - node.startingIndex];
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            Node<T> node = this.first;
            while (node != null) {
                for (int i = 0; i < node.elementDataPointer; ++i) {
                    if (node.elementData[i] == null) {
                        return index;
                    }
                    ++index;
                }
                node = node.next;
            }
        } else {
            Node<T> node = this.first;
            while (node != null) {
                for (int i = 0; i < node.elementDataPointer; ++i) {
                    if (o.equals(node.elementData[i])) {
                        return index;
                    }
                    ++index;
                }
                node = node.next;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = this.size - 1;
        if (o == null) {
            Node<T> node = this.last;
            while (node != null) {
                for (int i = node.elementDataPointer - 1; i >= 0; --i) {
                    if (node.elementData[i] == null) {
                        return index;
                    }
                    --index;
                }
                node = node.pre;
            }
        } else {
            Node<T> node = this.last;
            while (node != null) {
                for (int i = node.elementDataPointer - 1; i >= 0; --i) {
                    if (o.equals(node.elementData[i])) {
                        return index;
                    }
                    --index;
                }
                node = node.pre;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public T remove(int index) {
        Node<T> node;
        this.rangeCheck(index);
        if (this.size == 2 && this.first != this.last) {
            Node newNode = new Node(null, null, 0, 2);
            newNode.add(this.first.elementData[0]);
            newNode.add(this.last.elementData[0]);
            this.last = newNode;
            this.first = this.last;
            node = this.last;
        } else {
            node = this.getNode(index);
        }
        T[] elementData = node.elementData;
        int elementSize = node.elementDataPointer;
        int nodeArrIndex = index - node.startingIndex;
        Object oldValue = elementData[nodeArrIndex];
        int numMoved = elementSize - nodeArrIndex - 1;
        if (numMoved > 0) {
            System.arraycopy(node.elementData, nodeArrIndex + 1, node.elementData, nodeArrIndex, numMoved);
        }
        if (this.first == this.last || node == this.last) {
            node.elementData[elementSize - 1] = null;
        } else {
            node.elementData = Arrays.copyOf(node.elementData, elementSize - 1);
            node.endingIndex = --node.endingIndex < 0 ? 0 : node.endingIndex;
        }
        --node.elementDataPointer;
        this.updateNodesAfterRemove(node);
        if (node.elementDataPointer == 0 && this.first != this.last) {
            Node next = node.next;
            Node prev = node.pre;
            if (prev == null) {
                this.first = next;
            } else {
                prev.next = next;
                node.pre = null;
            }
            if (next == null) {
                this.last = prev;
            } else {
                next.pre = prev;
                node.next = null;
            }
            node.elementData = null;
        }
        --this.size;
        ++this.modCount;
        return oldValue;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        Objects.requireNonNull(c);
        Object[] arr = c.toArray();
        if (arr.length == 0) {
            return false;
        }
        boolean isModified = false;
        for (Object o : arr) {
            isModified |= this.remove(o);
        }
        return isModified;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        Object[] elements;
        Objects.requireNonNull(c);
        Object[] arr = c.toArray();
        if (arr.length == 0) {
            return false;
        }
        boolean isModified = false;
        for (Object element : elements = this.toArray()) {
            if (c.contains(element)) continue;
            isModified |= this.remove(element);
        }
        return isModified;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index != -1) {
            this.remove(index);
            return true;
        }
        return false;
    }

    private void updateNodesAfterRemove(Node<T> fromNode) {
        Node node = fromNode.next;
        while (node != null) {
            node.startingIndex = --node.startingIndex < 0 ? 0 : node.startingIndex;
            node.endingIndex = --node.endingIndex < 0 ? 0 : node.endingIndex;
            node = node.next;
        }
    }

    private Node<T> getNode(int index) {
        int firstStartingIndex = this.first.startingIndex;
        int firstEndingIndex = this.first.endingIndex;
        int firstMinDistance = FastMath.min(FastMath.abs(index - firstStartingIndex), FastMath.abs(index - firstEndingIndex));
        int lastStartingIndex = this.last.startingIndex;
        int lastEndingIndex = this.last.endingIndex;
        int lastMinDistance = FastMath.min(FastMath.abs(index - lastStartingIndex), FastMath.abs(index - lastEndingIndex));
        if (firstMinDistance <= lastMinDistance) {
            Node<T> node = this.first;
            while (true) {
                if (node.startingIndex <= index && index <= node.endingIndex) {
                    return node;
                }
                node = node.next;
            }
        }
        Node<T> node = this.last;
        while (node.startingIndex > index || index > node.endingIndex) {
            node = node.pre;
        }
        return node;
    }

    private Node<T> getNodeForAdd(int index) {
        if (index == this.size && (this.last.startingIndex > index || index > this.last.endingIndex)) {
            return null;
        }
        return this.getNode(index);
    }

    private void rangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    @Override
    public void clear() {
        Node<T> node = this.first;
        while (node != null) {
            Node next = node.next;
            node.next = null;
            node.pre = null;
            node.elementData = null;
            node = next;
        }
        this.last = null;
        this.first = null;
        int capacity = FastMath.min(0x7FFFFFF7, FastMath.max(this.size, FastMath.max(this.initialCapacity, 10)));
        Node initNode = new Node(null, null, 0, capacity);
        this.initialCapacity = capacity;
        this.first = initNode;
        this.last = initNode;
        ++this.modCount;
        this.size = 0;
    }

    public void trimToSize() {
        int pointer = this.last.elementDataPointer;
        int arrLen = this.last.elementData.length;
        if (pointer < arrLen && arrLen > 2) {
            if (pointer < 2) {
                this.last.elementData = Arrays.copyOf(this.last.elementData, 2);
                this.last.endingIndex -= arrLen - 2;
            } else {
                this.last.elementData = Arrays.copyOf(this.last.elementData, pointer);
                this.last.endingIndex -= arrLen - pointer;
            }
        }
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        return super.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        Object[] objects = new Object[this.size];
        int i = 0;
        Node<T> node = this.first;
        while (node != null) {
            int len = node.elementDataPointer;
            if (len > 0) {
                System.arraycopy(node.elementData, 0, objects, i, len);
            }
            i += len;
            node = node.next;
        }
        return objects;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return Arrays.copyOf(this.toArray(), this.size, a.getClass());
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Itr();
    }

    public Object clone() {
        try {
            GlueList clone = (GlueList)super.clone();
            clone.last = null;
            clone.first = null;
            int capacity = FastMath.min(0x7FFFFFF7, FastMath.max(clone.size, FastMath.max(clone.initialCapacity, 10)));
            Node initNode = new Node(null, null, 0, capacity);
            clone.initialCapacity = capacity;
            clone.last = initNode;
            clone.first = clone.last;
            clone.modCount = 0;
            clone.size = 0;
            Node<T> node = this.first;
            while (node != null) {
                for (int i = 0; i < node.elementDataPointer; ++i) {
                    clone.add((T)node.elementData[i]);
                }
                node = node.next;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        this.checkPositionIndex(index);
        return new ListItr(index);
    }

    private void checkPositionIndex(int index) {
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return new ListItr(0);
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int expectedModCount = this.modCount;
        s.defaultWriteObject();
        s.writeInt(this.size);
        Node<T> node = this.first;
        while (node != null) {
            for (int i = 0; i < node.elementDataPointer; ++i) {
                s.writeObject(node.elementData[i]);
            }
            node = node.next;
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.clear();
        s.defaultReadObject();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            this.last.add(s.readObject());
        }
    }

    protected static class Node<T> {
        protected Node<T> pre;
        protected Node<T> next;
        protected int listSize;
        protected int startingIndex;
        protected int endingIndex;
        protected T[] elementData;
        protected int elementDataPointer;

        Node(Node<T> pre, Node<T> next, int listSize) {
            this.pre = pre;
            this.next = next;
            this.listSize = listSize;
            this.elementData = new Object[listSize >>> 1];
            this.startingIndex = listSize;
            this.endingIndex = listSize + this.elementData.length - 1;
        }

        Node(Node<T> pre, Node<T> next, int listSize, int initialCapacity) {
            this.pre = pre;
            this.next = next;
            this.listSize = listSize;
            this.elementData = this.createElementData(initialCapacity);
            this.startingIndex = listSize;
            this.endingIndex = listSize + this.elementData.length - 1;
        }

        T[] createElementData(int capacity) {
            if (capacity == 0 || capacity == 1) {
                return new Object[10];
            }
            if (capacity > 1) {
                return new Object[capacity];
            }
            throw new IllegalArgumentException("Illegal Capacity: " + capacity);
        }

        boolean isAddable() {
            return this.elementDataPointer < this.elementData.length;
        }

        void add(T element) {
            this.elementData[this.elementDataPointer++] = element;
        }

        public String toString() {
            return String.format("[sIndex: %d - eIndex: %d | elementDataPointer: %d | elementDataLength: %d]", this.startingIndex, this.endingIndex, this.elementDataPointer, this.elementData.length);
        }
    }

    private class Itr
    implements Iterator<T> {
        protected Node<T> node;
        protected int i;
        protected int j;
        protected int lastReturn;
        protected int expectedModCount;
        protected int elementDataPointer;

        private Itr() {
            this.node = GlueList.this.first;
            this.i = 0;
            this.j = 0;
            this.lastReturn = -1;
            this.expectedModCount = GlueList.this.modCount;
            this.elementDataPointer = this.node.elementDataPointer;
        }

        @Override
        public boolean hasNext() {
            return this.j != GlueList.this.size;
        }

        @Override
        public T next() {
            this.checkForComodification();
            if (this.j >= GlueList.this.size) {
                throw new NoSuchElementException();
            }
            if (this.j >= ((GlueList)GlueList.this).last.endingIndex + 1) {
                throw new ConcurrentModificationException();
            }
            if (this.j == 0) {
                this.node = GlueList.this.first;
                this.elementDataPointer = this.node.elementDataPointer;
                this.i = 0;
            }
            Object val = this.node.elementData[this.i++];
            if (this.i >= this.elementDataPointer) {
                this.node = this.node.next;
                this.i = 0;
                this.elementDataPointer = this.node != null ? this.node.elementDataPointer : 0;
            }
            this.lastReturn = this.j++;
            return val;
        }

        @Override
        public void remove() {
            if (this.lastReturn < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                GlueList.this.remove(this.lastReturn);
                this.j = this.lastReturn;
                this.lastReturn = -1;
                this.i = --this.i < 0 ? 0 : this.i;
                this.elementDataPointer = this.node != null ? this.node.elementDataPointer : 0;
                this.expectedModCount = GlueList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        void checkForComodification() {
            if (GlueList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<T> {
        public ListItr(int index) {
            this.node = index == GlueList.this.size ? GlueList.this.last : GlueList.this.getNode(index);
            this.j = index;
            this.i = index - this.node.startingIndex;
            this.elementDataPointer = this.node.elementDataPointer;
        }

        @Override
        public boolean hasPrevious() {
            return this.j != 0;
        }

        @Override
        public T previous() {
            int index;
            this.checkForComodification();
            int temp = this.j - 1;
            if (temp < 0) {
                throw new NoSuchElementException();
            }
            if (temp >= ((GlueList)GlueList.this).last.endingIndex + 1) {
                throw new ConcurrentModificationException();
            }
            if (this.j == GlueList.this.size) {
                this.node = GlueList.this.last;
                this.i = this.elementDataPointer = this.node.elementDataPointer;
            }
            if ((index = this.j - this.node.startingIndex) == 0) {
                this.node = this.node.pre;
                this.i = this.elementDataPointer = this.node.elementDataPointer;
            }
            Object val = this.node.elementData[--this.i];
            if (this.i < 0) {
                this.node = this.node.pre;
                this.i = this.node != null ? this.node.elementDataPointer : 0;
            }
            this.lastReturn = this.j = temp;
            return val;
        }

        @Override
        public int nextIndex() {
            return this.j;
        }

        @Override
        public int previousIndex() {
            return this.j - 1;
        }

        @Override
        public void set(T t) {
            if (this.lastReturn < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                GlueList.this.set(this.lastReturn, t);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(T t) {
            this.checkForComodification();
            try {
                int temp = this.j;
                GlueList.this.add(temp, t);
                this.j = temp + 1;
                this.lastReturn = -1;
                ++this.i;
                this.elementDataPointer = this.node != null ? this.node.elementDataPointer : 0;
                this.expectedModCount = GlueList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

