/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ReflectionUtil {
    public static Field[] getFields(@NotNull Class<?> type) {
        Field[] result = type.getDeclaredFields();
        Class<?> parentClass = type.getSuperclass();
        if (parentClass != null) {
            result = (Field[])Stream.concat(Arrays.stream(result), Arrays.stream(ReflectionUtil.getFields(parentClass))).toArray(Field[]::new);
        }
        return result;
    }

    public static Method[] getMethods(@NotNull Class<?> type) {
        Method[] result = type.getDeclaredMethods();
        Class<?> parentClass = type.getSuperclass();
        if (parentClass != null) {
            result = (Method[])Stream.concat(Arrays.stream(result), Arrays.stream(ReflectionUtil.getMethods(parentClass))).toArray(Method[]::new);
        }
        return result;
    }

    public static <T extends Annotation> void ifAnnotationPresent(AnnotatedElement element, Class<? extends T> annotation, Consumer<T> operation) {
        T a = element.getAnnotation(annotation);
        if (a != null) {
            operation.accept(a);
        }
    }
}

