/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.util.collections;

import com.dfsek.terra.api.math.MathUtil;
import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.util.mutable.MutableInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ProbabilityCollection<E>
implements Collection<E> {
    protected final Map<E, MutableInteger> cont = new HashMap<E, MutableInteger>();
    private Object[] array = new Object[0];
    private int size;

    public ProbabilityCollection<E> add(E item, int probability) {
        if (!this.cont.containsKey(item)) {
            ++this.size;
        }
        this.cont.computeIfAbsent(item, i -> new MutableInteger(0)).increment();
        int oldLength = this.array.length;
        Object[] newArray = new Object[this.array.length + probability];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        this.array = newArray;
        for (int i2 = oldLength; i2 < this.array.length; ++i2) {
            this.array[i2] = item;
        }
        return this;
    }

    public E get(Random r) {
        if (this.array.length == 0) {
            return null;
        }
        return (E)this.array[r.nextInt(this.array.length)];
    }

    public E get(NoiseSampler n, double x, double y, double z) {
        if (this.array.length == 0) {
            return null;
        }
        return (E)this.array[MathUtil.normalizeIndex(n.getNoise(x, y, z), this.array.length)];
    }

    public E get(NoiseSampler n, double x, double z) {
        if (this.array.length == 0) {
            return null;
        }
        return (E)this.array[MathUtil.normalizeIndex(n.getNoise(x, z), this.array.length)];
    }

    public <T> ProbabilityCollection<T> map(Function<E, T> mapper, boolean carryNull) {
        ProbabilityCollection<E> newCollection = new ProbabilityCollection<E>();
        newCollection.array = new Object[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            if (carryNull && this.array[i] == null) continue;
            newCollection.array[i] = mapper.apply(this.array[i]);
        }
        return newCollection;
    }

    public int getTotalProbability() {
        return this.array.length;
    }

    public int getProbability(E item) {
        MutableInteger integer = this.cont.get(item);
        return integer == null ? 0 : (Integer)integer.get();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        this.cont.forEach((? super K item, ? super V prob) -> builder.append(item).append(": ").append(prob).append(", "));
        return builder.append("]").toString();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.cont.containsKey(o);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.cont.keySet().iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.cont.keySet().toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.cont.keySet().toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.add(e, 1);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot remove item from ProbabilityCollection!");
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.cont.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        c.forEach(this::add);
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("Cannot remove item from ProbabilityCollection!");
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("Cannot remove item from ProbabilityCollection!");
    }

    @Override
    public void clear() {
        this.cont.clear();
        this.array = new Object[0];
    }

    public Set<E> getContents() {
        return new HashSet<E>(this.cont.keySet());
    }

    public static final class Singleton<T>
    extends ProbabilityCollection<T> {
        private final T single;

        public Singleton(T single) {
            this.single = single;
            this.cont.put(single, new MutableInteger(1));
        }

        @Override
        public ProbabilityCollection<T> add(T item, int probability) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T1> ProbabilityCollection<T1> map(Function<T, T1> mapper, boolean carryNull) {
            if (carryNull && this.single == null) {
                return new Singleton<Object>(null);
            }
            return new Singleton<T1>(mapper.apply(this.single));
        }

        @Override
        public T get(Random r) {
            return this.single;
        }

        @Override
        public T get(NoiseSampler n, double x, double y, double z) {
            return this.single;
        }

        @Override
        public T get(NoiseSampler n, double x, double z) {
            return this.single;
        }

        @Override
        public int getTotalProbability() {
            return 1;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Set<T> getContents() {
            return Collections.singleton(this.single);
        }
    }
}

