/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.util.hash;

import java.io.Serializable;

public abstract class HashIntrinsic
implements Serializable {
    public static final int FLOAT_EXP_BIT_MASK = 2139095040;
    public static final int FLOAT_SIGNIF_BIT_MASK = 0x7FFFFF;
    public static final long DOUBLE_EXP_BIT_MASK = 0x7FF0000000000000L;
    public static final long DOUBLE_SIGNIF_BIT_MASK = 0xFFFFFFFFFFFFFL;
    protected static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 8058099372006904458L;
    protected int size;
    protected int threshold;
    protected float loadFactor;
    protected int capMinus1;

    protected HashIntrinsic(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (!(loadFactor <= 0.0f) && !Float.isNaN(loadFactor)) {
            if (initialCapacity > 0x40000000) {
                initialCapacity = 0x40000000;
            }
            for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
            }
        } else {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        this.capMinus1 = capacity - 1;
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
    }

    protected static int hashCodeLong(long value) {
        return (int)(value ^ value >>> 32);
    }

    protected static int hashCodeFloat(float value) {
        return HashIntrinsic.floatToIntBits(value);
    }

    protected static int hashCodeDouble(double value) {
        long bits = HashIntrinsic.doubleToLongBits(value);
        return (int)(bits ^ bits >>> 32);
    }

    public static int floatToIntBits(float value) {
        int result = Float.floatToRawIntBits(value);
        if ((result & 0x7F800000) == 2139095040 && (result & 0x7FFFFF) != 0) {
            result = 2143289344;
        }
        return result;
    }

    public static long doubleToLongBits(double value) {
        long result = Double.doubleToRawLongBits(value);
        if ((result & 0x7FF0000000000000L) == 0x7FF0000000000000L && (result & 0xFFFFFFFFFFFFFL) != 0L) {
            result = 9221120237041090560L;
        }
        return result;
    }

    protected static int tableIndex(int hc, int lm1) {
        hc ^= hc >>> 20 ^ hc >>> 12;
        hc ^= hc >>> 7 ^ hc >>> 4;
        return hc & lm1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public abstract void clear();
}

