/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.util.hash;

import com.dfsek.terra.api.util.hash.HashIntrinsic;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class HashMapDoubleDouble
extends HashIntrinsic {
    private static final long serialVersionUID = 2109458761298324234L;
    private Entry[] table;

    public HashMapDoubleDouble(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.table = this.createTable(this.capMinus1 + 1);
    }

    public HashMapDoubleDouble(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashMapDoubleDouble() {
        this(16, 0.75f);
    }

    public final boolean contains(double key) {
        int i = HashMapDoubleDouble.tableIndex(HashMapDoubleDouble.hashCodeDouble(key), this.capMinus1);
        Entry e = this.table[i];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public boolean containsValue(double value) {
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = this.table[i];
            while (e != null) {
                if (value == e.value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public double get(double key) {
        int i = HashMapDoubleDouble.tableIndex(HashMapDoubleDouble.hashCodeDouble(key), this.capMinus1);
        Entry e = this.table[i];
        while (e != null) {
            if (key == e.key) {
                return e.value;
            }
            e = e.next;
        }
        return Double.MIN_VALUE;
    }

    public Entry getEntry(double key) {
        int i = HashMapDoubleDouble.tableIndex(HashMapDoubleDouble.hashCodeDouble(key), this.capMinus1);
        Entry e = this.table[i];
        while (e != null) {
            if (key == e.key) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public double put(double key, double value) {
        int i = HashMapDoubleDouble.tableIndex(HashMapDoubleDouble.hashCodeDouble(key), this.capMinus1);
        Entry e = this.table[i];
        while (e != null) {
            if (key == e.key) {
                double oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        this.addEntry(key, value, i);
        return Double.MIN_VALUE;
    }

    private void addEntry(double key, double value, int index) {
        Entry e = this.table[index];
        this.table[index] = new Entry(key, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    public void resize(int newCapacity) {
        int oldCapacity = this.table.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
        } else {
            Entry[] newTable = this.createTable(newCapacity);
            this.capMinus1 = newCapacity - 1;
            this.transfer(newTable);
            this.table = newTable;
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        }
    }

    private void transfer(Entry[] newTable) {
        for (int j = 0; j < this.table.length; ++j) {
            Entry next;
            Entry e = this.table[j];
            if (e == null) continue;
            this.table[j] = null;
            do {
                next = e.next;
                int i = HashMapDoubleDouble.tableIndex(HashMapDoubleDouble.hashCodeDouble(e.key), this.capMinus1);
                e.next = newTable[i];
                newTable[i] = e;
                e = next;
            } while (next != null);
        }
    }

    public final Entry remove(double key) {
        Entry prev;
        int i = HashMapDoubleDouble.tableIndex(HashMapDoubleDouble.hashCodeDouble(key), this.capMinus1);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (key == e.key) {
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.size = 0;
    }

    private Entry[] createTable(int capacity) {
        return new Entry[capacity];
    }

    public long memoryEstimate(int ptrsize) {
        return (long)ptrsize * (long)(this.capMinus1 + this.size + 1) + (long)(this.size * 64 / 4);
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 7972173983741231238L;
        private final double key;
        private double value;
        private Entry next;

        public Entry(double key, double val, Entry n) {
            this.key = key;
            this.value = val;
            this.next = n;
        }

        public final double getKey() {
            return this.key;
        }

        public final double getValue() {
            return this.value;
        }

        public final double setValue(double newValue) {
            double oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public final boolean equals(Object o) {
            Entry e = (Entry)o;
            return this.key == e.key && this.value == e.value;
        }

        public final String toString() {
            return this.key + " = " + this.value;
        }

        public final int hashCode() {
            return HashIntrinsic.hashCodeDouble(this.key) + HashIntrinsic.hashCodeDouble(this.value);
        }
    }

    public class Iterator {
        Entry next;
        int index;
        Entry current;

        Iterator() {
            if (HashMapDoubleDouble.this.size > 0) {
                while (this.index < HashMapDoubleDouble.this.table.length && (this.next = HashMapDoubleDouble.this.table[this.index++]) == null) {
                }
            }
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        public Entry nextEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                while (this.index < HashMapDoubleDouble.this.table.length && (this.next = HashMapDoubleDouble.this.table[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        public double next() {
            return this.nextEntry().value;
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            double k = this.current.key;
            this.current = null;
            HashMapDoubleDouble.this.remove(k);
        }
    }
}

