/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.biome.pipeline;

import com.dfsek.terra.api.math.vector.Vector2;
import com.dfsek.terra.api.util.GlueList;
import com.dfsek.terra.api.util.seeded.StageSeeded;
import com.dfsek.terra.api.world.biome.pipeline.BiomeHolder;
import com.dfsek.terra.api.world.biome.pipeline.TerraBiomeHolder;
import com.dfsek.terra.api.world.biome.pipeline.source.BiomeSource;
import com.dfsek.terra.api.world.biome.pipeline.stages.Stage;
import java.util.List;
import java.util.stream.Collectors;

public class BiomePipeline {
    private final BiomeSource source;
    private final List<Stage> stages;
    private final int size;
    private final int init;

    private BiomePipeline(BiomeSource source, List<Stage> stages, int size, int init) {
        this.source = source;
        this.stages = stages;
        this.size = size;
        this.init = init;
    }

    public BiomeHolder getBiomes(int x, int z) {
        BiomeHolder holder = new TerraBiomeHolder(this.init, new Vector2(x * (this.init - 1), z * (this.init - 1)));
        holder.fill(this.source);
        for (Stage stage : this.stages) {
            holder = stage.apply(holder);
        }
        return holder;
    }

    public int getSize() {
        return this.size;
    }

    public static final class BiomePipelineBuilder {
        private final int init;
        List<StageSeeded> stages = new GlueList<StageSeeded>();
        private int expand;

        public BiomePipelineBuilder(int init) {
            this.init = init;
            this.expand = init;
        }

        public BiomePipeline build(BiomeSource source, long seed) {
            List stagesBuilt = this.stages.stream().map(stageBuilder -> (Stage)stageBuilder.apply(seed)).collect(Collectors.toList());
            for (Stage stage : stagesBuilt) {
                if (!stage.isExpansion()) continue;
                this.expand = this.expand * 2 - 1;
            }
            return new BiomePipeline(source, stagesBuilt, this.expand, this.init);
        }

        public BiomePipelineBuilder addStage(StageSeeded stage) {
            this.stages.add(stage);
            return this;
        }
    }
}

