/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.biome.pipeline;

import com.dfsek.terra.api.math.vector.Vector2;
import com.dfsek.terra.api.world.biome.TerraBiome;
import com.dfsek.terra.api.world.biome.pipeline.BiomeHolder;
import com.dfsek.terra.api.world.biome.pipeline.expand.BiomeExpander;
import com.dfsek.terra.api.world.biome.pipeline.mutator.BiomeMutator;
import com.dfsek.terra.api.world.biome.pipeline.source.BiomeSource;

public class TerraBiomeHolder
implements BiomeHolder {
    private final Vector2 origin;
    private final int width;
    private TerraBiome[][] biomes;
    private final int offset;

    public TerraBiomeHolder(int width, Vector2 origin) {
        this.width = width += 4;
        this.biomes = new TerraBiome[width][width];
        this.origin = origin;
        this.offset = 2;
    }

    private TerraBiomeHolder(TerraBiome[][] biomes, Vector2 origin, int width, int offset) {
        this.biomes = biomes;
        this.origin = origin;
        this.width = width;
        this.offset = 2 * offset;
    }

    @Override
    public BiomeHolder expand(BiomeExpander expander) {
        TerraBiome[][] old = this.biomes;
        int newWidth = this.width * 2 - 1;
        this.biomes = new TerraBiome[newWidth][newWidth];
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.width; ++z) {
                this.biomes[x * 2][z * 2] = old[x][z];
                if (z != this.width - 1) {
                    this.biomes[x * 2][z * 2 + 1] = expander.getBetween((double)x + this.origin.getX(), (double)(z + 1) + this.origin.getZ(), old[x][z], old[x][z + 1]);
                }
                if (x != this.width - 1) {
                    this.biomes[x * 2 + 1][z * 2] = expander.getBetween((double)(x + 1) + this.origin.getX(), (double)z + this.origin.getZ(), old[x][z], old[x + 1][z]);
                }
                if (x == this.width - 1 || z == this.width - 1) continue;
                this.biomes[x * 2 + 1][z * 2 + 1] = expander.getBetween((double)(x + 1) + this.origin.getX(), (double)(z + 1) + this.origin.getZ(), old[x][z], old[x + 1][z + 1], old[x][z + 1], old[x + 1][z]);
            }
        }
        return new TerraBiomeHolder(this.biomes, this.origin.setX(this.origin.getX() * 2.0 - 1.0).setZ(this.origin.getZ() * 2.0 - 1.0), newWidth, this.offset);
    }

    @Override
    public void mutate(BiomeMutator mutator) {
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.width; ++z) {
                BiomeMutator.ViewPoint viewPoint = new BiomeMutator.ViewPoint(this, x, z);
                this.biomes[x][z] = mutator.mutate(viewPoint, (double)x + this.origin.getX(), (double)z + this.origin.getZ());
            }
        }
    }

    @Override
    public void fill(BiomeSource source) {
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.width; ++z) {
                this.biomes[x][z] = source.getBiome(this.origin.getX() + (double)x, this.origin.getZ() + (double)z);
            }
        }
    }

    @Override
    public TerraBiome getBiome(int x, int z) {
        return this.getBiomeRaw(x += this.offset, z += this.offset);
    }

    @Override
    public TerraBiome getBiomeRaw(int x, int z) {
        if (x >= this.width || z >= this.width || x < 0 || z < 0) {
            return null;
        }
        return this.biomes[x][z];
    }
}

