/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.biome.pipeline.mutator;

import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.util.collections.ProbabilityCollection;
import com.dfsek.terra.api.world.biome.TerraBiome;
import com.dfsek.terra.api.world.biome.pipeline.mutator.BiomeMutator;
import java.util.Map;

public class BorderListMutator
implements BiomeMutator {
    private final String border;
    private final NoiseSampler noiseSampler;
    private final ProbabilityCollection<TerraBiome> replaceDefault;
    private final String defaultReplace;
    private final Map<TerraBiome, ProbabilityCollection<TerraBiome>> replace;

    public BorderListMutator(Map<TerraBiome, ProbabilityCollection<TerraBiome>> replace, String border, String defaultReplace, NoiseSampler noiseSampler, ProbabilityCollection<TerraBiome> replaceDefault) {
        this.border = border;
        this.noiseSampler = noiseSampler;
        this.replaceDefault = replaceDefault;
        this.defaultReplace = defaultReplace;
        this.replace = replace;
    }

    @Override
    public TerraBiome mutate(BiomeMutator.ViewPoint viewPoint, double x, double z) {
        TerraBiome origin = viewPoint.getBiome(0, 0);
        if (origin.getTags().contains(this.defaultReplace)) {
            for (int xi = -1; xi <= 1; ++xi) {
                for (int zi = -1; zi <= 1; ++zi) {
                    TerraBiome current;
                    if (xi == 0 && zi == 0 || (current = viewPoint.getBiome(xi, zi)) == null || !current.getTags().contains(this.border)) continue;
                    if (this.replace.containsKey(origin)) {
                        TerraBiome biome = this.replace.get(origin).get(this.noiseSampler, x, z);
                        return biome == null ? origin : biome;
                    }
                    TerraBiome biome = this.replaceDefault.get(this.noiseSampler, x, z);
                    return biome == null ? origin : biome;
                }
            }
        }
        return origin;
    }
}

