/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.biome.pipeline.mutator;

import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.util.collections.ProbabilityCollection;
import com.dfsek.terra.api.world.biome.TerraBiome;
import com.dfsek.terra.api.world.biome.pipeline.mutator.BiomeMutator;

public class BorderMutator
implements BiomeMutator {
    private final String border;
    private final NoiseSampler noiseSampler;
    private final ProbabilityCollection<TerraBiome> replace;
    private final String replaceTag;

    public BorderMutator(String border, String replaceTag, NoiseSampler noiseSampler, ProbabilityCollection<TerraBiome> replace) {
        this.border = border;
        this.noiseSampler = noiseSampler;
        this.replace = replace;
        this.replaceTag = replaceTag;
    }

    @Override
    public TerraBiome mutate(BiomeMutator.ViewPoint viewPoint, double x, double z) {
        TerraBiome origin = viewPoint.getBiome(0, 0);
        if (origin.getTags().contains(this.replaceTag)) {
            for (int xi = -1; xi <= 1; ++xi) {
                for (int zi = -1; zi <= 1; ++zi) {
                    TerraBiome current;
                    if (xi == 0 && zi == 0 || (current = viewPoint.getBiome(xi, zi)) == null || !current.getTags().contains(this.border)) continue;
                    TerraBiome biome = this.replace.get(this.noiseSampler, x, z);
                    return biome == null ? origin : biome;
                }
            }
        }
        return origin;
    }
}

