/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.biome.pipeline.mutator;

import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.util.collections.ProbabilityCollection;
import com.dfsek.terra.api.world.biome.TerraBiome;
import com.dfsek.terra.api.world.biome.pipeline.mutator.BiomeMutator;
import java.util.Map;

public class ReplaceListMutator
implements BiomeMutator {
    private final Map<TerraBiome, ProbabilityCollection<TerraBiome>> replace;
    private final NoiseSampler sampler;
    private final ProbabilityCollection<TerraBiome> replaceDefault;
    private final String defaultTag;

    public ReplaceListMutator(Map<TerraBiome, ProbabilityCollection<TerraBiome>> replace, String defaultTag, ProbabilityCollection<TerraBiome> replaceDefault, NoiseSampler sampler) {
        this.replace = replace;
        this.sampler = sampler;
        this.defaultTag = defaultTag;
        this.replaceDefault = replaceDefault;
    }

    @Override
    public TerraBiome mutate(BiomeMutator.ViewPoint viewPoint, double x, double z) {
        TerraBiome center = viewPoint.getBiome(0, 0);
        if (this.replace.containsKey(center)) {
            TerraBiome biome = this.replace.get(center).get(this.sampler, x, z);
            return biome == null ? viewPoint.getBiome(0, 0) : biome;
        }
        if (viewPoint.getBiome(0, 0).getTags().contains(this.defaultTag)) {
            TerraBiome biome = this.replaceDefault.get(this.sampler, x, z);
            return biome == null ? viewPoint.getBiome(0, 0) : biome;
        }
        return center;
    }
}

