/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.biome.pipeline.mutator;

import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.util.collections.ProbabilityCollection;
import com.dfsek.terra.api.world.biome.TerraBiome;
import com.dfsek.terra.api.world.biome.pipeline.mutator.BiomeMutator;

public class ReplaceMutator
implements BiomeMutator {
    private final String replaceableTag;
    private final ProbabilityCollection<TerraBiome> replace;
    private final NoiseSampler sampler;

    public ReplaceMutator(String replaceable, ProbabilityCollection<TerraBiome> replace, NoiseSampler sampler) {
        this.replaceableTag = replaceable;
        this.replace = replace;
        this.sampler = sampler;
    }

    @Override
    public TerraBiome mutate(BiomeMutator.ViewPoint viewPoint, double x, double z) {
        if (viewPoint.getBiome(0, 0).getTags().contains(this.replaceableTag)) {
            TerraBiome biome = this.replace.get(this.sampler, x, z);
            return biome == null ? viewPoint.getBiome(0, 0) : biome;
        }
        return viewPoint.getBiome(0, 0);
    }
}

