/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.biome.provider;

import com.dfsek.terra.api.world.biome.TerraBiome;
import com.dfsek.terra.api.world.biome.provider.BiomeProvider;
import com.dfsek.terra.lib.jafama.FastMath;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ImageBiomeProvider
implements BiomeProvider,
BiomeProvider.BiomeProviderBuilder {
    private final Map<Color, TerraBiome> colorBiomeMap = new HashMap<Color, TerraBiome>();
    private final BufferedImage image;
    private final int resolution;
    private final Align align;

    public ImageBiomeProvider(Set<TerraBiome> registry, BufferedImage image, int resolution, Align align) {
        this.image = image;
        this.resolution = resolution;
        this.align = align;
        registry.forEach(biome -> this.colorBiomeMap.put(new Color(biome.getColor()), (TerraBiome)biome));
    }

    private static int distance(Color a, Color b) {
        return FastMath.abs(a.getRed() - b.getRed()) + FastMath.abs(a.getGreen() - b.getGreen()) + FastMath.abs(a.getBlue() - b.getBlue());
    }

    @Override
    public TerraBiome getBiome(int x, int z) {
        Color color = this.align.getColor(this.image, x /= this.resolution, z /= this.resolution);
        return this.colorBiomeMap.get(this.colorBiomeMap.keySet().stream().reduce((Color)this.colorBiomeMap.keySet().stream().findAny().orElseThrow(IllegalStateException::new), (running, element) -> {
            int d2;
            int d1 = ImageBiomeProvider.distance(color, running);
            return d1 < (d2 = ImageBiomeProvider.distance(color, element)) ? running : element;
        }));
    }

    @Override
    public BiomeProvider build(long seed) {
        return this;
    }

    public static enum Align {
        CENTER{

            @Override
            public Color getColor(BufferedImage image, int x, int z) {
                return new Color(image.getRGB(FastMath.floorMod(x - image.getWidth() / 2, image.getWidth()), FastMath.floorMod(z - image.getHeight() / 2, image.getHeight())));
            }
        }
        ,
        NONE{

            @Override
            public Color getColor(BufferedImage image, int x, int z) {
                return new Color(image.getRGB(FastMath.floorMod(x, image.getWidth()), FastMath.floorMod(z, image.getHeight())));
            }
        };


        public abstract Color getColor(BufferedImage var1, int var2, int var3);
    }
}

