/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.biome.provider;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.math.vector.Vector2;
import com.dfsek.terra.api.world.biome.TerraBiome;
import com.dfsek.terra.api.world.biome.pipeline.BiomeHolder;
import com.dfsek.terra.api.world.biome.pipeline.BiomePipeline;
import com.dfsek.terra.api.world.biome.provider.BiomeProvider;
import com.dfsek.terra.lib.jafama.FastMath;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.jetbrains.annotations.NotNull;

public class StandardBiomeProvider
implements BiomeProvider {
    private final LoadingCache<Vector2, BiomeHolder> holderCache;
    private final BiomePipeline pipeline;
    private final int resolution;
    private final NoiseSampler mutator;
    private final double noiseAmp;
    private final int seed;

    public StandardBiomeProvider(final BiomePipeline pipeline, TerraPlugin main, int resolution, NoiseSampler mutator, double noiseAmp, int seed) {
        this.resolution = resolution;
        this.mutator = mutator;
        this.noiseAmp = noiseAmp;
        this.seed = seed;
        this.holderCache = CacheBuilder.newBuilder().maximumSize(main == null ? 32L : (long)main.getTerraConfig().getProviderCache()).build((CacheLoader)new CacheLoader<Vector2, BiomeHolder>(){

            public BiomeHolder load(@NotNull Vector2 key) {
                return pipeline.getBiomes(key.getBlockX(), key.getBlockZ());
            }
        });
        this.pipeline = pipeline;
    }

    @Override
    public TerraBiome getBiome(int x, int z) {
        x = (int)((double)x + this.mutator.getNoiseSeeded(this.seed, x, z) * this.noiseAmp);
        z = (int)((double)z + this.mutator.getNoiseSeeded(1 + this.seed, x, z) * this.noiseAmp);
        x = FastMath.floorToInt(FastMath.floorDiv(x, this.resolution));
        z = FastMath.floorToInt(FastMath.floorDiv(z, this.resolution));
        int fdX = FastMath.floorDiv(x, this.pipeline.getSize());
        int fdZ = FastMath.floorDiv(z, this.pipeline.getSize());
        return ((BiomeHolder)this.holderCache.getUnchecked((Object)new Vector2(fdX, fdZ))).getBiome(x - fdX * this.pipeline.getSize(), z - fdZ * this.pipeline.getSize());
    }
}

