/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.carving;

import com.dfsek.terra.api.math.vector.Vector3;
import com.dfsek.terra.api.platform.world.World;
import com.dfsek.terra.api.world.carving.Worm;
import com.dfsek.terra.lib.jafama.FastMath;
import java.util.Random;
import java.util.function.BiConsumer;

public abstract class Carver {
    private final int minY;
    private final int maxY;
    private final double sixtyFourSq = FastMath.pow(64.0, 2.0);
    private int carvingRadius = 4;

    public Carver(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
    }

    public abstract void carve(int var1, int var2, World var3, BiConsumer<Vector3, CarvingType> var4);

    public int getCarvingRadius() {
        return this.carvingRadius;
    }

    public void setCarvingRadius(int carvingRadius) {
        this.carvingRadius = carvingRadius;
    }

    public abstract Worm getWorm(long var1, Vector3 var3);

    public abstract boolean isChunkCarved(World var1, int var2, int var3, Random var4);

    public static enum CarvingType {
        CENTER,
        WALL,
        TOP,
        BOTTOM;

    }
}

