/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.locate;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.math.vector.Location;
import com.dfsek.terra.api.math.vector.Vector3;
import com.dfsek.terra.api.world.biome.TerraBiome;
import com.dfsek.terra.api.world.biome.provider.BiomeProvider;
import com.dfsek.terra.api.world.locate.AsyncFeatureFinder;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class AsyncBiomeFinder
extends AsyncFeatureFinder<TerraBiome> {
    public AsyncBiomeFinder(BiomeProvider provider, TerraBiome target, @NotNull Location origin, int startRadius, int maxRadius, Consumer<Vector3> callback, TerraPlugin main) {
        super(provider, target, origin, startRadius, maxRadius, callback, main);
    }

    @Override
    public boolean isValid(int x, int z, TerraBiome target) {
        int res = this.main.getTerraConfig().getBiomeSearchResolution();
        return this.getProvider().getBiome(x * res, z * res).equals(target);
    }

    @Override
    public Vector3 finalizeVector(Vector3 orig) {
        return orig.multiply(this.main.getTerraConfig().getBiomeSearchResolution());
    }
}

