/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.locate;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.math.vector.Location;
import com.dfsek.terra.api.math.vector.Vector3;
import com.dfsek.terra.api.platform.world.World;
import com.dfsek.terra.api.world.biome.provider.BiomeProvider;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class AsyncFeatureFinder<T>
implements Runnable {
    protected final BiomeProvider provider;
    protected final T target;
    protected final int startRadius;
    protected final int maxRadius;
    protected final int centerX;
    protected final int centerZ;
    protected final World world;
    private final Consumer<Vector3> callback;
    protected int searchSize = 1;
    protected final TerraPlugin main;

    public AsyncFeatureFinder(BiomeProvider provider, T target, @NotNull Location origin, int startRadius, int maxRadius, Consumer<Vector3> callback, TerraPlugin main) {
        this.provider = provider;
        this.target = target;
        this.main = main;
        this.startRadius = startRadius;
        this.maxRadius = maxRadius;
        this.centerX = origin.getBlockX();
        this.centerZ = origin.getBlockZ();
        this.world = origin.getWorld();
        this.callback = callback;
    }

    @Override
    public void run() {
        int x = this.centerX;
        int z = this.centerZ;
        x /= this.searchSize;
        z /= this.searchSize;
        int run = 1;
        boolean toggle = true;
        boolean found = false;
        block0: for (int i = this.startRadius; i < this.maxRadius; ++i) {
            int j;
            for (j = 0; j < run; ++j) {
                if (this.isValid(x, z, this.target)) {
                    found = true;
                    break block0;
                }
                if (toggle) {
                    ++x;
                    continue;
                }
                --x;
            }
            for (j = 0; j < run; ++j) {
                if (this.isValid(x, z, this.target)) {
                    found = true;
                    break block0;
                }
                if (toggle) {
                    ++z;
                    continue;
                }
                --z;
            }
            ++run;
            toggle = !toggle;
        }
        Vector3 finalSpawn = found ? this.finalizeVector(new Vector3(x, 0.0, z)) : null;
        this.callback.accept(finalSpawn);
    }

    public abstract Vector3 finalizeVector(Vector3 var1);

    public abstract boolean isValid(int var1, int var2, T var3);

    public T getTarget() {
        return this.target;
    }

    public World getWorld() {
        return this.world;
    }

    public BiomeProvider getProvider() {
        return this.provider;
    }

    public int getSearchSize() {
        return this.searchSize;
    }

    public void setSearchSize(int searchSize) {
        this.searchSize = searchSize;
    }
}

