/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.palette;

import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.util.GlueList;
import com.dfsek.terra.api.util.collections.ProbabilityCollection;
import java.util.List;
import java.util.Random;

public abstract class Palette<E> {
    private final List<PaletteLayer<E>> pallet = new GlueList<PaletteLayer<E>>();

    public Palette<E> add(E m, int layers, NoiseSampler sampler) {
        for (int i = 0; i < layers; ++i) {
            this.pallet.add(new PaletteLayer<E>(m, sampler));
        }
        return this;
    }

    public Palette<E> add(ProbabilityCollection<E> m, int layers, NoiseSampler sampler) {
        for (int i = 0; i < layers; ++i) {
            this.pallet.add(new PaletteLayer<ProbabilityCollection<E>>(m, sampler));
        }
        return this;
    }

    public abstract E get(int var1, double var2, double var4, double var6);

    public int getSize() {
        return this.pallet.size();
    }

    public List<PaletteLayer<E>> getLayers() {
        return this.pallet;
    }

    public static class PaletteLayer<E> {
        private final boolean col;
        private ProbabilityCollection<E> collection;
        private final NoiseSampler sampler;
        private E m;

        public PaletteLayer(ProbabilityCollection<E> type, NoiseSampler sampler) {
            this.sampler = sampler;
            this.col = true;
            this.collection = type;
        }

        public PaletteLayer(E type, NoiseSampler sampler) {
            this.sampler = sampler;
            this.col = false;
            this.m = type;
        }

        public NoiseSampler getSampler() {
            return this.sampler;
        }

        public E get(Random random) {
            if (this.col) {
                return this.collection.get(random);
            }
            return this.m;
        }

        public E get(NoiseSampler random, double x, double y, double z, boolean is2D) {
            if (this.col && is2D) {
                return this.collection.get(random, x, z);
            }
            if (this.col) {
                return this.collection.get(random, x, y, z);
            }
            return this.m;
        }

        public ProbabilityCollection<E> getCollection() {
            return this.collection;
        }
    }
}

