/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.world.palette.holder;

import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.world.palette.Palette;
import com.dfsek.terra.api.world.palette.holder.PaletteHolder;
import com.dfsek.terra.lib.jafama.FastMath;
import java.util.Map;
import java.util.TreeMap;

public class PaletteHolderBuilder {
    private final TreeMap<Integer, Palette<BlockData>> paletteMap = new TreeMap();

    public PaletteHolderBuilder add(int y, Palette<BlockData> palette) {
        this.paletteMap.put(y, palette);
        return this;
    }

    public PaletteHolder build() {
        Palette[] palettes = new Palette[this.paletteMap.lastKey() + 1];
        for (int y = 0; y <= FastMath.max(this.paletteMap.lastKey(), 255); ++y) {
            Palette<BlockData> d = null;
            for (Map.Entry<Integer, Palette<BlockData>> e : this.paletteMap.entrySet()) {
                if (e.getKey() < y) continue;
                d = e.getValue();
                break;
            }
            if (d == null) {
                throw new IllegalArgumentException("No palette for Y=" + y);
            }
            palettes[y] = d;
        }
        return new PaletteHolder(palettes);
    }
}

