/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.carving;

import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.platform.block.BlockType;
import com.dfsek.terra.api.util.collections.MaterialSet;
import com.dfsek.terra.api.util.collections.ProbabilityCollection;
import java.util.Map;
import java.util.TreeMap;

public class CarverPalette {
    private final boolean blacklist;
    private final MaterialSet replace;
    private final TreeMap<Integer, ProbabilityCollection<BlockData>> map = new TreeMap();
    private ProbabilityCollection<BlockData>[] layers;

    public CarverPalette(MaterialSet replaceable, boolean blacklist) {
        this.blacklist = blacklist;
        this.replace = replaceable;
    }

    public CarverPalette add(ProbabilityCollection<BlockData> collection, int y) {
        this.map.put(y, collection);
        return this;
    }

    public ProbabilityCollection<BlockData> get(int y) {
        return this.layers[y];
    }

    public boolean canReplace(BlockType material) {
        return this.blacklist != this.replace.contains(material);
    }

    public void build() {
        int size = this.map.lastKey() + 1;
        this.layers = new ProbabilityCollection[size];
        for (int y = 0; y < size; ++y) {
            ProbabilityCollection<BlockData> d = null;
            for (Map.Entry<Integer, ProbabilityCollection<BlockData>> e : this.map.entrySet()) {
                if (e.getKey() < y) continue;
                d = e.getValue();
                break;
            }
            if (d == null) {
                throw new IllegalArgumentException("Null collection at Y=" + y);
            }
            this.layers[y] = d;
        }
    }
}

