/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.carving;

import com.dfsek.paralithic.Expression;
import com.dfsek.paralithic.eval.parser.Parser;
import com.dfsek.paralithic.eval.parser.Scope;
import com.dfsek.paralithic.eval.tokenizer.ParseException;
import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.math.Range;
import com.dfsek.terra.api.math.paralithic.defined.UserDefinedFunction;
import com.dfsek.terra.api.math.paralithic.noise.NoiseFunction2;
import com.dfsek.terra.api.math.paralithic.noise.NoiseFunction3;
import com.dfsek.terra.api.math.vector.Vector3;
import com.dfsek.terra.api.platform.world.World;
import com.dfsek.terra.api.util.FastRandom;
import com.dfsek.terra.api.util.seeded.NoiseSeeded;
import com.dfsek.terra.api.world.biome.UserDefinedBiome;
import com.dfsek.terra.api.world.carving.Carver;
import com.dfsek.terra.api.world.carving.Worm;
import com.dfsek.terra.carving.CarverCache;
import com.dfsek.terra.config.loaders.config.function.FunctionTemplate;
import com.dfsek.terra.config.templates.BiomeTemplate;
import com.dfsek.terra.config.templates.CarverTemplate;
import com.dfsek.terra.lib.jafama.FastMath;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public class UserDefinedCarver
extends Carver {
    private final double[] start;
    private final double[] mutate;
    private final Range length;
    private final long hash;
    private final int topCut;
    private final int bottomCut;
    private final CarverTemplate config;
    private final Expression xRad;
    private final Expression yRad;
    private final Expression zRad;
    private final Map<Long, CarverCache> cacheMap = new ConcurrentHashMap<Long, CarverCache>();
    private final TerraPlugin main;
    private double step = 2.0;
    private Range recalc = new Range(8, 10);
    private double recalcMagnitude = 3.0;

    public UserDefinedCarver(Range height, Range length, double[] start, double[] mutate, List<String> radii, Scope parent, long hash, int topCut, int bottomCut, CarverTemplate config, TerraPlugin main, Map<String, NoiseSeeded> functions, Map<String, FunctionTemplate> definedFunctions) throws ParseException {
        super(height.getMin(), height.getMax());
        this.length = length;
        this.start = start;
        this.mutate = mutate;
        this.hash = hash;
        this.topCut = topCut;
        this.bottomCut = bottomCut;
        this.config = config;
        this.main = main;
        Parser p = new Parser();
        functions.forEach((id, noise) -> {
            switch (noise.getDimensions()) {
                case 2: {
                    p.registerFunction((String)id, new NoiseFunction2(noise.apply(hash)));
                    break;
                }
                case 3: {
                    p.registerFunction((String)id, new NoiseFunction3(noise.apply(hash)));
                }
            }
        });
        for (Map.Entry<String, FunctionTemplate> entry : definedFunctions.entrySet()) {
            p.registerFunction(entry.getKey(), UserDefinedFunction.newInstance(entry.getValue(), p, parent));
        }
        Scope s = new Scope().withParent(parent);
        s.addInvocationVariable("x");
        s.addInvocationVariable("y");
        s.addInvocationVariable("z");
        s.addInvocationVariable("length");
        s.addInvocationVariable("position");
        s.addInvocationVariable("seed");
        this.xRad = p.parse(radii.get(0), s);
        this.yRad = p.parse(radii.get(1), s);
        this.zRad = p.parse(radii.get(2), s);
    }

    @Override
    public Worm getWorm(long l, Vector3 vector) {
        FastRandom r = new FastRandom(l + this.hash);
        return new UserDefinedWorm(this.length.get(r) / 2, r, vector, this.topCut, this.bottomCut, l);
    }

    public void setStep(double step) {
        this.step = step;
    }

    public void setRecalc(Range recalc) {
        this.recalc = recalc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void carve(int chunkX, int chunkZ, World w, BiConsumer<Vector3, Carver.CarvingType> consumer) {
        Map<Long, CarverCache> map = this.cacheMap;
        synchronized (map) {
            CarverCache cache = this.cacheMap.computeIfAbsent(w.getSeed(), world -> new CarverCache(w, this.main, this));
            int carvingRadius = this.getCarvingRadius();
            for (int x = chunkX - carvingRadius; x <= chunkX + carvingRadius; ++x) {
                for (int z = chunkZ - carvingRadius; z <= chunkZ + carvingRadius; ++z) {
                    cache.getPoints(x, z).forEach(point -> {
                        Vector3 origin = point.getOrigin();
                        if (FastMath.floorDiv(origin.getBlockX(), 16) != chunkX && FastMath.floorDiv(origin.getBlockZ(), 16) != chunkZ) {
                            return;
                        }
                        point.carve(chunkX, chunkZ, consumer);
                    });
                }
            }
        }
    }

    public void setRecalcMagnitude(double recalcMagnitude) {
        this.recalcMagnitude = recalcMagnitude;
    }

    @Override
    public boolean isChunkCarved(World w, int chunkX, int chunkZ, Random random) {
        BiomeTemplate conf = ((UserDefinedBiome)this.main.getWorld(w).getBiomeProvider().getBiome((chunkX << 4) + 8, (chunkZ << 4) + 8)).getConfig();
        if (conf.getCarvers().get(this) != null) {
            return new FastRandom(random.nextLong() + this.hash).nextInt(100) < conf.getCarvers().get(this);
        }
        return false;
    }

    public CarverTemplate getConfig() {
        return this.config;
    }

    private class UserDefinedWorm
    extends Worm {
        private final Vector3 direction;
        private final Vector3 origin;
        private int steps;
        private int nextDirection;
        private double[] currentRotation;
        private final long seed;

        public UserDefinedWorm(int length, Random r, Vector3 origin, int topCut, int bottomCut, long seed) {
            super(length, r, origin);
            this.nextDirection = 0;
            this.currentRotation = new double[3];
            this.origin = origin;
            this.seed = seed;
            super.setTopCut(topCut);
            super.setBottomCut(bottomCut);
            this.direction = new Vector3((r.nextDouble() - 0.5) * UserDefinedCarver.this.start[0], (r.nextDouble() - 0.5) * UserDefinedCarver.this.start[1], (r.nextDouble() - 0.5) * UserDefinedCarver.this.start[2]).normalize().multiply(UserDefinedCarver.this.step);
            double[] args = new double[]{origin.getX(), origin.getY(), origin.getZ(), length, 0.0, seed};
            this.setRadius(new int[]{(int)UserDefinedCarver.this.xRad.evaluate(args), (int)UserDefinedCarver.this.yRad.evaluate(args), (int)UserDefinedCarver.this.zRad.evaluate(args)});
        }

        @Override
        public Worm.WormPoint getPoint() {
            return new Worm.WormPoint(this.getRunning().clone(), this.getRadius(), UserDefinedCarver.this.config.getCutTop(), UserDefinedCarver.this.config.getCutBottom());
        }

        @Override
        public void step() {
            if (this.steps == this.nextDirection) {
                this.direction.rotateAroundX(FastMath.toRadians(this.getRandom().nextGaussian() * UserDefinedCarver.this.mutate[0] * UserDefinedCarver.this.recalcMagnitude));
                this.direction.rotateAroundY(FastMath.toRadians(this.getRandom().nextGaussian() * UserDefinedCarver.this.mutate[1] * UserDefinedCarver.this.recalcMagnitude));
                this.direction.rotateAroundZ(FastMath.toRadians(this.getRandom().nextGaussian() * UserDefinedCarver.this.mutate[2] * UserDefinedCarver.this.recalcMagnitude));
                this.currentRotation = new double[]{this.getRandom().nextGaussian() * UserDefinedCarver.this.mutate[0], this.getRandom().nextGaussian() * UserDefinedCarver.this.mutate[1], this.getRandom().nextGaussian() * UserDefinedCarver.this.mutate[2]};
                this.nextDirection += UserDefinedCarver.this.recalc.get(this.getRandom());
            }
            ++this.steps;
            double[] args = new double[]{this.origin.getX(), this.origin.getY(), this.origin.getZ(), this.getLength(), this.steps, this.seed};
            this.setRadius(new int[]{(int)UserDefinedCarver.this.xRad.evaluate(args), (int)UserDefinedCarver.this.yRad.evaluate(args), (int)UserDefinedCarver.this.zRad.evaluate(args)});
            this.direction.rotateAroundX(FastMath.toRadians(this.currentRotation[0] * UserDefinedCarver.this.mutate[0]));
            this.direction.rotateAroundY(FastMath.toRadians(this.currentRotation[1] * UserDefinedCarver.this.mutate[1]));
            this.direction.rotateAroundZ(FastMath.toRadians(this.currentRotation[2] * UserDefinedCarver.this.mutate[2]));
            this.getRunning().add(this.direction);
        }
    }
}

