/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.commands.biome;

import com.dfsek.terra.api.command.CommandTemplate;
import com.dfsek.terra.api.command.annotation.Argument;
import com.dfsek.terra.api.command.annotation.Command;
import com.dfsek.terra.api.command.annotation.inject.ArgumentTarget;
import com.dfsek.terra.api.platform.CommandSender;
import com.dfsek.terra.api.world.biome.TerraBiome;
import com.dfsek.terra.api.world.biome.UserDefinedBiome;
import com.dfsek.terra.commands.biome.arg.BiomeArgumentParser;
import com.dfsek.terra.commands.biome.tab.BiomeTabCompleter;
import com.dfsek.terra.config.templates.BiomeTemplate;
import com.dfsek.terra.world.population.items.TerraStructure;
import java.util.List;

@Command(arguments={@Argument(value="biome", tabCompleter=BiomeTabCompleter.class, argumentParser=BiomeArgumentParser.class)})
public class BiomeInfoCommand
implements CommandTemplate {
    @ArgumentTarget(value="biome")
    private TerraBiome biome;

    @Override
    public void execute(CommandSender sender) {
        sender.sendMessage("Biome info for \"" + this.biome.getID() + "\".");
        sender.sendMessage("Vanilla biome: " + this.biome.getVanillaBiomes());
        if (this.biome instanceof UserDefinedBiome) {
            List<TerraStructure> structureConfigs;
            BiomeTemplate bio = ((UserDefinedBiome)this.biome).getConfig();
            if (bio.getExtend() != null) {
                sender.sendMessage("Extends: " + bio.getExtend());
            }
            if ((structureConfigs = bio.getStructures()).size() == 0) {
                sender.sendMessage("No Structures");
            } else {
                sender.sendMessage("-------Structures-------");
                for (TerraStructure c : structureConfigs) {
                    sender.sendMessage(" - " + c.getTemplate().getID());
                }
            }
        }
    }
}

