/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.commands.structure;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.command.CommandTemplate;
import com.dfsek.terra.api.command.annotation.Argument;
import com.dfsek.terra.api.command.annotation.Command;
import com.dfsek.terra.api.command.annotation.Switch;
import com.dfsek.terra.api.command.annotation.inject.ArgumentTarget;
import com.dfsek.terra.api.command.annotation.inject.SwitchTarget;
import com.dfsek.terra.api.command.annotation.type.DebugCommand;
import com.dfsek.terra.api.command.annotation.type.PlayerCommand;
import com.dfsek.terra.api.command.annotation.type.WorldCommand;
import com.dfsek.terra.api.command.arg.IntegerArgumentParser;
import com.dfsek.terra.api.injection.annotations.Inject;
import com.dfsek.terra.api.platform.CommandSender;
import com.dfsek.terra.api.platform.entity.Player;
import com.dfsek.terra.api.structures.script.StructureScript;
import com.dfsek.terra.api.structures.structure.Rotation;
import com.dfsek.terra.api.util.FastRandom;
import com.dfsek.terra.commands.structure.argument.ScriptArgumentParser;
import com.dfsek.terra.commands.structure.completer.RotationCompleter;
import com.dfsek.terra.commands.structure.completer.ScriptCompleter;
import java.util.concurrent.ThreadLocalRandom;

@PlayerCommand
@DebugCommand
@WorldCommand
@Command(arguments={@Argument(value="structure", tabCompleter=ScriptCompleter.class, argumentParser=ScriptArgumentParser.class), @Argument(value="rotation", required=false, tabCompleter=RotationCompleter.class, argumentParser=IntegerArgumentParser.class, defaultValue="0")}, switches={@Switch(value="chunk", aliases={"c"})}, usage="/terra structure load [ROTATION] [-c]")
public class StructureLoadCommand
implements CommandTemplate {
    @ArgumentTarget(value="rotation")
    private Integer rotation = 0;
    @SwitchTarget(value="chunk")
    private boolean chunk;
    @ArgumentTarget(value="structure")
    private StructureScript script;
    @Inject
    private TerraPlugin main;

    @Override
    public void execute(CommandSender sender) {
        Rotation r;
        Player player = (Player)sender;
        long t = System.nanoTime();
        FastRandom random = new FastRandom(ThreadLocalRandom.current().nextLong());
        try {
            r = Rotation.fromDegrees(this.rotation);
        }
        catch (Exception e) {
            sender.sendMessage("Invalid rotation: " + this.rotation);
            return;
        }
        if (this.script == null) {
            sender.sendMessage("Invalid structure.");
            return;
        }
        if (this.chunk) {
            this.script.execute(player.getLocation(), player.getWorld().getChunkAt(player.getLocation()), random, r);
        } else {
            this.script.execute(player.getLocation(), random, r);
        }
        long l = System.nanoTime() - t;
        sender.sendMessage("Took " + (double)l / 1000000.0 + "ms");
    }
}

