/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config;

import com.dfsek.tectonic.annotations.Default;
import com.dfsek.tectonic.annotations.Value;
import com.dfsek.tectonic.config.ConfigTemplate;
import com.dfsek.tectonic.exception.ConfigException;
import com.dfsek.tectonic.loading.ConfigLoader;
import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.util.JarUtil;
import com.dfsek.terra.api.util.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.jar.JarFile;

public class PluginConfig
implements ConfigTemplate {
    @Value(value="debug")
    @Default
    private boolean debug = false;
    @Value(value="language")
    @Default
    private String language = "en_us";
    @Value(value="data-save")
    @Default
    private Duration dataSave = Duration.parse("PT6M");
    @Value(value="biome-search-resolution")
    @Default
    private int biomeSearch = 4;
    @Value(value="cache.carver")
    @Default
    private int carverCache = 256;
    @Value(value="cache.structure")
    @Default
    private int structureCache = 32;
    @Value(value="cache.sampler")
    @Default
    private int samplerCache = 64;
    @Value(value="cache.biome")
    @Default
    private int biomeCache = 512;
    @Value(value="cache.biome-provider")
    @Default
    private int providerCache = 32;
    @Value(value="dump-default")
    @Default
    private boolean dumpDefaultConfig = true;
    @Value(value="script.max-recursion")
    @Default
    private int maxRecursion = 1000;

    public void load(TerraPlugin main) {
        Logger logger;
        block15: {
            logger = main.logger();
            logger.info("Loading config values");
            try (FileInputStream file = new FileInputStream(new File(main.getDataFolder(), "config.yml"));){
                ConfigLoader loader = new ConfigLoader();
                loader.load((ConfigTemplate)this, file);
                if (!this.dumpDefaultConfig) break block15;
                try (JarFile jar = main.getModJar();){
                    JarUtil.copyResourcesToDirectory(jar, "packs", new File(main.getDataFolder(), "packs").toString());
                }
                catch (IOException | URISyntaxException e) {
                    main.getDebugLogger().error("Failed to dump default config files!");
                    e.printStackTrace();
                    main.getDebugLogger().error("Either you're on Forge, or this is a bug. If it's the latter, report this to Terra!");
                }
            }
            catch (ConfigException | IOException e) {
                e.printStackTrace();
            }
        }
        logger.info("DebugLogger: " + this.isDebug());
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public long getDataSaveInterval() {
        return this.dataSave.toMillis() / 20L;
    }

    public int getBiomeSearchResolution() {
        return this.biomeSearch;
    }

    public int getCarverCacheSize() {
        return this.carverCache;
    }

    public int getStructureCache() {
        return this.structureCache;
    }

    public int getSamplerCache() {
        return this.samplerCache;
    }

    public int getMaxRecursion() {
        return this.maxRecursion;
    }

    public int getBiomeCache() {
        return this.biomeCache;
    }

    public int getProviderCache() {
        return this.providerCache;
    }
}

