/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config.builder;

import com.dfsek.paralithic.eval.parser.Scope;
import com.dfsek.paralithic.eval.tokenizer.ParseException;
import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.math.noise.samplers.ExpressionSampler;
import com.dfsek.terra.api.math.noise.samplers.noise.ConstantSampler;
import com.dfsek.terra.api.platform.world.Biome;
import com.dfsek.terra.api.util.collections.ProbabilityCollection;
import com.dfsek.terra.api.util.seeded.NoiseSeeded;
import com.dfsek.terra.api.world.biome.UserDefinedBiome;
import com.dfsek.terra.config.builder.BiomeBuilder;
import com.dfsek.terra.config.loaders.config.function.FunctionTemplate;
import com.dfsek.terra.config.pack.ConfigPack;
import com.dfsek.terra.config.templates.BiomeTemplate;
import com.dfsek.terra.world.generation.WorldGenerator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UserDefinedBiomeBuilder
implements BiomeBuilder {
    private final BiomeTemplate template;
    private final ConfigPack pack;
    private final Map<Long, UserDefinedBiome> biomeMap = new ConcurrentHashMap<Long, UserDefinedBiome>();

    public UserDefinedBiomeBuilder(BiomeTemplate template, ConfigPack pack) {
        this.template = template;
        this.pack = pack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDefinedBiome apply(Long seed) {
        Map<Long, UserDefinedBiome> map = this.biomeMap;
        synchronized (map) {
            return this.biomeMap.computeIfAbsent(seed, s -> {
                ExpressionSampler carving;
                NoiseSampler elevation;
                ExpressionSampler noise;
                Scope varScope = new Scope().withParent(this.pack.getVarScope());
                this.template.getVariables().forEach(varScope::create);
                Map<String, NoiseSeeded> noiseBuilderMap = this.pack.getTemplate().getNoiseBuilderMap();
                LinkedHashMap<String, FunctionTemplate> functionTemplateMap = new LinkedHashMap<String, FunctionTemplate>(this.pack.getTemplate().getFunctions());
                functionTemplateMap.putAll(this.template.getFunctions());
                try {
                    noise = new ExpressionSampler(this.template.getNoiseEquation(), varScope, seed, noiseBuilderMap, functionTemplateMap);
                    elevation = this.template.getElevationEquation() == null ? new ConstantSampler(0.0) : new ExpressionSampler(this.template.getElevationEquation(), varScope, seed, noiseBuilderMap, functionTemplateMap);
                    carving = new ExpressionSampler(this.template.getCarvingEquation(), varScope, seed, noiseBuilderMap, functionTemplateMap);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
                WorldGenerator generator = new WorldGenerator(this.template.getPalette(), this.template.getSlantPalette(), noise, elevation, carving, this.template.getBiomeNoise().apply(seed), this.template.getElevationWeight(), this.template.getBlendDistance(), this.template.getBlendStep(), this.template.getBlendWeight());
                return new UserDefinedBiome(this.template.getVanilla(), generator, this.template);
            });
        }
    }

    @Override
    public ProbabilityCollection<Biome> getVanillaBiomes() {
        return this.template.getVanilla();
    }

    @Override
    public BiomeTemplate getTemplate() {
        return this.template;
    }
}

