/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config.fileloaders;

import com.dfsek.tectonic.config.Configuration;
import com.dfsek.tectonic.exception.ConfigException;
import com.dfsek.terra.api.util.GlueList;
import com.dfsek.terra.config.fileloaders.ExceptionalConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Loader {
    protected final Map<String, InputStream> streams = new HashMap<String, InputStream>();

    public Loader then(ExceptionalConsumer<List<Configuration>> consumer) throws ConfigException {
        GlueList list = new GlueList();
        this.streams.forEach((id, stream) -> list.add(new Configuration((InputStream)stream, (String)id)));
        consumer.accept(list);
        return this;
    }

    public Loader thenNames(ExceptionalConsumer<List<String>> consumer) throws ConfigException {
        consumer.accept(new GlueList<String>(this.streams.keySet()));
        return this;
    }

    public Loader thenEntries(ExceptionalConsumer<Set<Map.Entry<String, InputStream>>> consumer) throws ConfigException {
        consumer.accept(this.streams.entrySet());
        return this;
    }

    public abstract InputStream get(String var1) throws IOException;

    public Loader open(String directory, String extension) {
        if (this.streams.size() != 0) {
            throw new IllegalStateException("Attempted to load new directory before closing existing InputStreams");
        }
        this.load(directory, extension);
        return this;
    }

    protected abstract void load(String var1, String var2);

    public Loader close() {
        this.streams.forEach((name, input) -> {
            try {
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.streams.clear();
        return this;
    }
}

