/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config.fileloaders;

import com.dfsek.terra.config.fileloaders.Loader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZIPLoader
extends Loader {
    private final ZipFile file;

    public ZIPLoader(ZipFile file) {
        this.file = file;
    }

    @Override
    public InputStream get(String singleFile) throws IOException {
        Enumeration<? extends ZipEntry> entries = this.file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().equals(singleFile)) continue;
            return this.file.getInputStream(entry);
        }
        throw new IllegalArgumentException("No such file: " + singleFile);
    }

    @Override
    protected void load(String directory, String extension) {
        Enumeration<? extends ZipEntry> entries = this.file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().startsWith(directory) || !entry.getName().endsWith(extension)) continue;
            try {
                String rel = entry.getName().substring(directory.length() + 1);
                this.streams.put(rel, this.file.getInputStream(entry));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

