/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config.lang;

import com.dfsek.terra.api.platform.CommandSender;
import com.dfsek.terra.config.lang.Message;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiLineMessage
implements Message {
    private final List<String> message;

    public MultiLineMessage(List<String> message) {
        this.message = message;
    }

    @Override
    public void log(Logger logger, Level level, String ... args) {
        for (String line : this.message) {
            logger.log(level, String.format(line, Arrays.asList(args).toArray()));
        }
    }

    @Override
    public void send(CommandSender sender, String ... args) {
        for (String line : this.message) {
            sender.sendMessage(String.format(line, Arrays.asList(args).toArray()));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.message == null || this.message.isEmpty();
    }
}

