/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config.loaders;

import com.dfsek.tectonic.exception.LoadException;
import com.dfsek.tectonic.loading.ConfigLoader;
import com.dfsek.tectonic.loading.TypeLoader;
import com.dfsek.terra.api.util.collections.ProbabilityCollection;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class ProbabilityCollectionLoader
implements TypeLoader<ProbabilityCollection<Object>> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProbabilityCollection<Object> load(Type type, Object o, ConfigLoader configLoader) throws LoadException {
        ProbabilityCollection<Object> collection = new ProbabilityCollection<Object>();
        if (!(type instanceof ParameterizedType)) throw new LoadException("Unable to load config! Could not retrieve parameterized type: " + type);
        ParameterizedType pType = (ParameterizedType)type;
        Type generic = pType.getActualTypeArguments()[0];
        if (o instanceof Map) {
            Map map = (Map)o;
            for (Map.Entry entry : map.entrySet()) {
                collection.add(configLoader.loadType(generic, entry.getKey()), (Integer)entry.getValue());
            }
            return collection;
        } else if (o instanceof List) {
            List map = (List)o;
            for (Map l : map) {
                for (Map.Entry entry : l.entrySet()) {
                    if (entry.getValue() == null) {
                        throw new LoadException("No probability defined for entry \"" + entry.getKey() + "\"");
                    }
                    Object val = configLoader.loadType(generic, entry.getKey());
                    collection.add(val, (Integer)entry.getValue());
                }
            }
            return collection;
        } else {
            if (!(o instanceof String)) throw new LoadException("Malformed Probability Collection: " + o);
            return new ProbabilityCollection.Singleton<Object>(configLoader.loadType(generic, o));
        }
    }
}

