/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config.loaders.config.biome;

import com.dfsek.tectonic.exception.LoadException;
import com.dfsek.tectonic.loading.ConfigLoader;
import com.dfsek.tectonic.loading.TypeLoader;
import com.dfsek.terra.api.util.seeded.StageSeeded;
import com.dfsek.terra.api.world.biome.pipeline.stages.ExpanderStage;
import com.dfsek.terra.api.world.biome.pipeline.stages.MutatorStage;
import com.dfsek.terra.config.loaders.config.biome.templates.stage.expander.ExpanderStageTemplate;
import com.dfsek.terra.config.loaders.config.biome.templates.stage.mutator.BorderListMutatorTemplate;
import com.dfsek.terra.config.loaders.config.biome.templates.stage.mutator.BorderMutatorTemplate;
import com.dfsek.terra.config.loaders.config.biome.templates.stage.mutator.ReplaceListMutatorTemplate;
import com.dfsek.terra.config.loaders.config.biome.templates.stage.mutator.ReplaceMutatorTemplate;
import com.dfsek.terra.config.loaders.config.biome.templates.stage.mutator.SmoothMutatorTemplate;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;

public class StageBuilderLoader
implements TypeLoader<StageSeeded> {
    @Override
    public StageSeeded load(Type t, Object c, ConfigLoader loader) throws LoadException {
        Map raw = (Map)c;
        if (raw.size() != 1) {
            throw new LoadException("Illegal stage map size: " + raw.size());
        }
        Map.Entry entry = null;
        Iterator iterator = raw.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e;
            entry = e = iterator.next();
        }
        Map mutator = (Map)entry.getValue();
        if (((String)entry.getKey()).equals("expand")) {
            ExpanderStage.Type stageType = loader.loadClass(ExpanderStage.Type.class, mutator.get("type"));
            if (stageType.equals((Object)ExpanderStage.Type.FRACTAL)) {
                return loader.loadClass(ExpanderStageTemplate.class, mutator);
            }
            throw new LoadException("No such expander \"" + (Object)((Object)stageType) + "\"");
        }
        if (((String)entry.getKey()).equals("mutate")) {
            switch (loader.loadClass(MutatorStage.Type.class, mutator.get("type"))) {
                case SMOOTH: {
                    return loader.loadClass(SmoothMutatorTemplate.class, mutator);
                }
                case REPLACE: {
                    return loader.loadClass(ReplaceMutatorTemplate.class, mutator);
                }
                case REPLACE_LIST: {
                    return loader.loadClass(ReplaceListMutatorTemplate.class, mutator);
                }
                case BORDER: {
                    return loader.loadClass(BorderMutatorTemplate.class, mutator);
                }
                case BORDER_LIST: {
                    return loader.loadClass(BorderListMutatorTemplate.class, mutator);
                }
            }
            throw new LoadException("No such mutator type \"" + mutator.get("type"));
        }
        throw new LoadException("No such mutator \"" + (String)entry.getKey() + "\"");
    }
}

