/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config.loaders.config.sampler.templates;

import com.dfsek.tectonic.annotations.Default;
import com.dfsek.tectonic.annotations.Value;
import com.dfsek.tectonic.config.ValidatedConfigTemplate;
import com.dfsek.tectonic.exception.ValidationException;
import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.math.noise.samplers.KernelSampler;
import com.dfsek.terra.api.util.seeded.NoiseSeeded;
import com.dfsek.terra.config.loaders.config.sampler.templates.SamplerTemplate;
import java.util.List;

public class KernelTemplate
extends SamplerTemplate<KernelSampler>
implements ValidatedConfigTemplate {
    @Value(value="kernel")
    private List<List<Double>> kernel;
    @Value(value="factor")
    @Default
    private double factor = 1.0;
    @Value(value="function")
    private NoiseSeeded function;
    @Value(value="frequency")
    @Default
    private double frequency = 1.0;

    @Override
    public NoiseSampler apply(Long seed) {
        double[][] k = new double[this.kernel.size()][this.kernel.get(0).size()];
        for (int x = 0; x < this.kernel.size(); ++x) {
            for (int y = 0; y < this.kernel.get(x).size(); ++y) {
                k[x][y] = this.kernel.get(x).get(y) * this.factor;
            }
        }
        KernelSampler sampler = new KernelSampler(k, this.function.apply(seed));
        sampler.setFrequency(this.frequency);
        return sampler;
    }

    @Override
    public boolean validate() throws ValidationException {
        if (this.kernel.isEmpty()) {
            throw new ValidationException("Kernel must not be empty.");
        }
        int len = this.kernel.get(0).size();
        if (len == 0) {
            throw new ValidationException("Kernel row must contain data.");
        }
        for (int i = 0; i < this.kernel.size(); ++i) {
            if (this.kernel.get(i).size() == len) continue;
            throw new ValidationException("Kernel row " + i + " size mismatch. Expected " + len + ", found " + this.kernel.get(i).size());
        }
        return super.validate();
    }
}

