/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config.loaders.config.sampler.templates.noise;

import com.dfsek.tectonic.annotations.Default;
import com.dfsek.tectonic.annotations.Value;
import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.math.noise.samplers.noise.CellularSampler;
import com.dfsek.terra.api.math.noise.samplers.noise.simplex.OpenSimplex2Sampler;
import com.dfsek.terra.api.util.seeded.NoiseSeeded;
import com.dfsek.terra.config.loaders.config.sampler.templates.noise.NoiseTemplate;

public class CellularNoiseTemplate
extends NoiseTemplate<CellularSampler> {
    @Value(value="distance")
    @Default
    private CellularSampler.DistanceFunction cellularDistanceFunction = CellularSampler.DistanceFunction.EuclideanSq;
    @Value(value="return")
    @Default
    private CellularSampler.ReturnType cellularReturnType = CellularSampler.ReturnType.Distance;
    @Value(value="jitter")
    @Default
    private double cellularJitter = 1.0;
    @Value(value="lookup")
    @Default
    private NoiseSeeded lookup = new NoiseSeeded(){

        @Override
        public NoiseSampler apply(Long seed) {
            return new OpenSimplex2Sampler((int)seed.longValue());
        }

        @Override
        public int getDimensions() {
            return 2;
        }
    };

    @Override
    public NoiseSampler apply(Long seed) {
        CellularSampler sampler = new CellularSampler((int)seed.longValue() + this.salt);
        sampler.setNoiseLookup(this.lookup.apply(seed));
        sampler.setFrequency(this.frequency);
        sampler.setJitterModifier(this.cellularJitter);
        sampler.setReturnType(this.cellularReturnType);
        sampler.setDistanceFunction(this.cellularDistanceFunction);
        return sampler;
    }
}

