/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config.loaders.config.sampler.templates.noise;

import com.dfsek.paralithic.eval.parser.Parser;
import com.dfsek.paralithic.eval.parser.Scope;
import com.dfsek.paralithic.eval.tokenizer.ParseException;
import com.dfsek.paralithic.functions.Function;
import com.dfsek.tectonic.annotations.Default;
import com.dfsek.tectonic.annotations.Value;
import com.dfsek.tectonic.config.ValidatedConfigTemplate;
import com.dfsek.tectonic.exception.ValidationException;
import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.math.noise.samplers.noise.ExpressionFunction;
import com.dfsek.terra.api.math.paralithic.defined.UserDefinedFunction;
import com.dfsek.terra.api.math.paralithic.noise.NoiseFunction2;
import com.dfsek.terra.api.math.paralithic.noise.NoiseFunction3;
import com.dfsek.terra.api.util.seeded.NoiseSeeded;
import com.dfsek.terra.config.loaders.config.function.FunctionTemplate;
import com.dfsek.terra.config.loaders.config.sampler.templates.SamplerTemplate;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExpressionFunctionTemplate
extends SamplerTemplate<ExpressionFunction>
implements ValidatedConfigTemplate {
    @Value(value="variables")
    @Default
    private Map<String, Double> vars = new HashMap<String, Double>();
    @Value(value="equation")
    private String equation;
    @Value(value="functions")
    @Default
    private LinkedHashMap<String, NoiseSeeded> functions = new LinkedHashMap();
    @Value(value="expressions")
    @Default
    private LinkedHashMap<String, FunctionTemplate> expressions = new LinkedHashMap();

    @Override
    public NoiseSampler apply(Long seed) {
        try {
            Map<String, Function> noiseFunctionMap = this.generateFunctions(seed);
            return new ExpressionFunction(noiseFunctionMap, this.equation, this.vars);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean validate() throws ValidationException {
        try {
            Map<String, Function> noiseFunctionMap = this.generateFunctions(0L);
            new ExpressionFunction(noiseFunctionMap, this.equation, this.vars);
        }
        catch (ParseException e) {
            throw new ValidationException("Errors occurred while parsing noise equation: ", e);
        }
        return super.validate();
    }

    private Map<String, Function> generateFunctions(Long seed) throws ParseException {
        HashMap<String, Function> noiseFunctionMap = new HashMap<String, Function>();
        for (Map.Entry<String, FunctionTemplate> entry : this.expressions.entrySet()) {
            noiseFunctionMap.put(entry.getKey(), UserDefinedFunction.newInstance(entry.getValue(), new Parser(), new Scope()));
        }
        this.functions.forEach((id, function) -> {
            if (function.getDimensions() == 2) {
                noiseFunctionMap.put((String)id, new NoiseFunction2(function.apply(seed)));
            } else {
                noiseFunctionMap.put((String)id, new NoiseFunction3(function.apply(seed)));
            }
        });
        return noiseFunctionMap;
    }
}

