/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config.pack;

import com.dfsek.paralithic.eval.parser.Scope;
import com.dfsek.tectonic.abstraction.AbstractConfigLoader;
import com.dfsek.tectonic.config.ConfigTemplate;
import com.dfsek.tectonic.config.Configuration;
import com.dfsek.tectonic.exception.ConfigException;
import com.dfsek.tectonic.exception.LoadException;
import com.dfsek.tectonic.loading.ConfigLoader;
import com.dfsek.tectonic.loading.TypeRegistry;
import com.dfsek.tectonic.loading.object.ObjectTemplate;
import com.dfsek.terra.api.LoaderRegistrar;
import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.event.events.config.ConfigPackPostLoadEvent;
import com.dfsek.terra.api.event.events.config.ConfigPackPreLoadEvent;
import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.platform.world.Tree;
import com.dfsek.terra.api.registry.CheckedRegistry;
import com.dfsek.terra.api.structures.loot.LootTable;
import com.dfsek.terra.api.structures.parser.exceptions.ParseException;
import com.dfsek.terra.api.structures.parser.lang.functions.FunctionBuilder;
import com.dfsek.terra.api.structures.script.StructureScript;
import com.dfsek.terra.api.util.seeded.NoiseSeeded;
import com.dfsek.terra.api.world.biome.provider.BiomeProvider;
import com.dfsek.terra.api.world.flora.Flora;
import com.dfsek.terra.api.world.palette.Palette;
import com.dfsek.terra.carving.UserDefinedCarver;
import com.dfsek.terra.config.builder.BiomeBuilder;
import com.dfsek.terra.config.dummy.DummyWorld;
import com.dfsek.terra.config.factories.BiomeFactory;
import com.dfsek.terra.config.factories.CarverFactory;
import com.dfsek.terra.config.factories.ConfigFactory;
import com.dfsek.terra.config.factories.FloraFactory;
import com.dfsek.terra.config.factories.OreFactory;
import com.dfsek.terra.config.factories.PaletteFactory;
import com.dfsek.terra.config.factories.StructureFactory;
import com.dfsek.terra.config.factories.TreeFactory;
import com.dfsek.terra.config.fileloaders.FolderLoader;
import com.dfsek.terra.config.fileloaders.Loader;
import com.dfsek.terra.config.fileloaders.ZIPLoader;
import com.dfsek.terra.config.loaders.config.BufferedImageLoader;
import com.dfsek.terra.config.loaders.config.biome.templates.provider.BiomePipelineTemplate;
import com.dfsek.terra.config.loaders.config.biome.templates.provider.ImageProviderTemplate;
import com.dfsek.terra.config.loaders.config.biome.templates.provider.SingleBiomeProviderTemplate;
import com.dfsek.terra.config.loaders.config.sampler.NoiseSamplerBuilderLoader;
import com.dfsek.terra.config.loaders.config.sampler.templates.ImageSamplerTemplate;
import com.dfsek.terra.config.pack.ConfigPackPostTemplate;
import com.dfsek.terra.config.pack.ConfigPackTemplate;
import com.dfsek.terra.config.pack.WorldConfig;
import com.dfsek.terra.config.templates.AbstractableTemplate;
import com.dfsek.terra.config.templates.BiomeTemplate;
import com.dfsek.terra.config.templates.CarverTemplate;
import com.dfsek.terra.config.templates.FloraTemplate;
import com.dfsek.terra.config.templates.OreTemplate;
import com.dfsek.terra.config.templates.PaletteTemplate;
import com.dfsek.terra.config.templates.StructureTemplate;
import com.dfsek.terra.config.templates.TreeTemplate;
import com.dfsek.terra.lib.commons.io.IOUtils;
import com.dfsek.terra.registry.OpenRegistry;
import com.dfsek.terra.registry.config.BiomeRegistry;
import com.dfsek.terra.registry.config.CarverRegistry;
import com.dfsek.terra.registry.config.FloraRegistry;
import com.dfsek.terra.registry.config.FunctionRegistry;
import com.dfsek.terra.registry.config.LootRegistry;
import com.dfsek.terra.registry.config.NoiseRegistry;
import com.dfsek.terra.registry.config.OreRegistry;
import com.dfsek.terra.registry.config.PaletteRegistry;
import com.dfsek.terra.registry.config.ScriptRegistry;
import com.dfsek.terra.registry.config.StructureRegistry;
import com.dfsek.terra.registry.config.TreeRegistry;
import com.dfsek.terra.world.TerraWorld;
import com.dfsek.terra.world.population.items.TerraStructure;
import com.dfsek.terra.world.population.items.ores.Ore;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ConfigPack
implements LoaderRegistrar {
    private final ConfigPackTemplate template = new ConfigPackTemplate();
    private final BiomeRegistry biomeRegistry = new BiomeRegistry();
    private final StructureRegistry structureRegistry = new StructureRegistry();
    private final PaletteRegistry paletteRegistry;
    private final FloraRegistry floraRegistry;
    private final OreRegistry oreRegistry = new OreRegistry();
    private final TreeRegistry treeRegistry;
    private final ScriptRegistry scriptRegistry = new ScriptRegistry();
    private final LootRegistry lootRegistry = new LootRegistry();
    private final CarverRegistry carverRegistry = new CarverRegistry();
    private final NoiseRegistry noiseRegistry = new NoiseRegistry();
    private final FunctionRegistry functionRegistry = new FunctionRegistry();
    private final AbstractConfigLoader abstractConfigLoader = new AbstractConfigLoader();
    private final ConfigLoader selfLoader = new ConfigLoader();
    private final Scope varScope = new Scope();
    private final TerraPlugin main;
    private final Loader loader;
    private final Configuration configuration;
    private final BiomeProvider.BiomeProviderBuilder biomeProviderBuilder;

    public ConfigPack(File folder, TerraPlugin main) throws ConfigException {
        try {
            this.loader = new FolderLoader(folder.toPath());
            this.main = main;
            long l = System.nanoTime();
            this.floraRegistry = new FloraRegistry(main);
            this.paletteRegistry = new PaletteRegistry(main);
            this.treeRegistry = new TreeRegistry();
            this.register(this.abstractConfigLoader);
            this.register(this.selfLoader);
            main.register(this.selfLoader);
            main.register(this.abstractConfigLoader);
            File pack = new File(folder, "pack.yml");
            try {
                this.configuration = new Configuration(new FileInputStream(pack));
                this.selfLoader.load((ConfigTemplate)this.template, this.configuration);
                main.logger().info("Loading config pack \"" + this.template.getID() + "\"");
                main.getEventManager().callEvent(new ConfigPackPreLoadEvent(this, template -> this.selfLoader.load(template, this.configuration)));
                this.load(l, main);
                ConfigPackPostTemplate packPostTemplate = new ConfigPackPostTemplate();
                this.selfLoader.load((ConfigTemplate)packPostTemplate, new FileInputStream(pack));
                this.biomeProviderBuilder = packPostTemplate.getProviderBuilder();
                this.biomeProviderBuilder.build(0L);
                this.checkDeadEntries(main);
            }
            catch (FileNotFoundException e) {
                throw new LoadException("No pack.yml file found in " + folder.getAbsolutePath(), e);
            }
        }
        catch (Exception e) {
            main.logger().severe("Failed to load config pack from folder \"" + folder.getAbsolutePath() + "\"");
            throw e;
        }
        this.toWorldConfig(new TerraWorld(new DummyWorld(), this, main));
    }

    public ConfigPack(ZipFile file, TerraPlugin main) throws ConfigException {
        try {
            this.loader = new ZIPLoader(file);
            this.main = main;
            long l = System.nanoTime();
            this.floraRegistry = new FloraRegistry(main);
            this.paletteRegistry = new PaletteRegistry(main);
            this.treeRegistry = new TreeRegistry();
            this.register(this.abstractConfigLoader);
            this.register(this.selfLoader);
            main.register(this.selfLoader);
            main.register(this.abstractConfigLoader);
            try {
                ZipEntry pack = null;
                Enumeration<? extends ZipEntry> entries = file.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().equals("pack.yml")) continue;
                    pack = entry;
                }
                if (pack == null) {
                    throw new LoadException("No pack.yml file found in " + file.getName());
                }
                this.configuration = new Configuration(file.getInputStream(pack));
                this.selfLoader.load((ConfigTemplate)this.template, this.configuration);
                main.logger().info("Loading config pack \"" + this.template.getID() + "\"");
                main.getEventManager().callEvent(new ConfigPackPreLoadEvent(this, template -> this.selfLoader.load(template, this.configuration)));
                this.load(l, main);
                ConfigPackPostTemplate packPostTemplate = new ConfigPackPostTemplate();
                this.selfLoader.load((ConfigTemplate)packPostTemplate, file.getInputStream(pack));
                this.biomeProviderBuilder = packPostTemplate.getProviderBuilder();
                this.biomeProviderBuilder.build(0L);
                this.checkDeadEntries(main);
            }
            catch (IOException e) {
                throw new LoadException("Unable to load pack.yml from ZIP file", e);
            }
        }
        catch (Exception e) {
            main.logger().severe("Failed to load config pack from ZIP archive \"" + file.getName() + "\"");
            throw e;
        }
        this.toWorldConfig(new TerraWorld(new DummyWorld(), this, main));
    }

    public static <C extends AbstractableTemplate, O> void buildAll(ConfigFactory<C, O> factory, OpenRegistry<O> registry, List<C> configTemplates, TerraPlugin main) throws LoadException {
        for (AbstractableTemplate template : configTemplates) {
            registry.add(template.getID(), factory.build(template, main));
        }
    }

    private void checkDeadEntries(TerraPlugin main) {
        this.biomeRegistry.getDeadEntries().forEach((id, value) -> main.getDebugLogger().warn("Dead entry in biome registry: '" + id + "'"));
        this.paletteRegistry.getDeadEntries().forEach((id, value) -> main.getDebugLogger().warn("Dead entry in palette registry: '" + id + "'"));
        this.floraRegistry.getDeadEntries().forEach((id, value) -> main.getDebugLogger().warn("Dead entry in flora registry: '" + id + "'"));
        this.carverRegistry.getDeadEntries().forEach((id, value) -> main.getDebugLogger().warn("Dead entry in carver registry: '" + id + "'"));
        this.treeRegistry.getDeadEntries().forEach((id, value) -> main.getDebugLogger().warn("Dead entry in tree registry: '" + id + "'"));
        this.oreRegistry.getDeadEntries().forEach((id, value) -> main.getDebugLogger().warn("Dead entry in ore registry: '" + id + "'"));
    }

    private void load(long start, TerraPlugin main) throws ConfigException {
        for (Map.Entry<String, Double> var : this.template.getVariables().entrySet()) {
            this.varScope.create(var.getKey(), var.getValue());
        }
        this.loader.open("structures/data", ".tesf").thenEntries(entries -> {
            for (Map.Entry entry : entries) {
                try {
                    InputStream stream = (InputStream)entry.getValue();
                    try {
                        StructureScript structureScript = new StructureScript(stream, main, this.scriptRegistry, this.lootRegistry, this.functionRegistry);
                        this.scriptRegistry.add(structureScript.getId(), structureScript);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (ParseException | IOException e) {
                    throw new LoadException("Unable to load script \"" + (String)entry.getKey() + "\"", e);
                }
            }
        }).close().open("structures/loot", ".json").thenEntries(entries -> {
            for (Map.Entry entry : entries) {
                try {
                    this.lootRegistry.add((String)entry.getKey(), new LootTable(IOUtils.toString((InputStream)entry.getValue(), StandardCharsets.UTF_8), main));
                }
                catch (com.dfsek.terra.lib.json.simple.parser.ParseException | IOException | NullPointerException e) {
                    throw new LoadException("Unable to load loot table \"" + (String)entry.getKey() + "\"", e);
                }
            }
        }).close();
        this.loader.open("carving", ".yml").then(configs -> ConfigPack.buildAll(new CarverFactory(this), this.carverRegistry, this.abstractConfigLoader.loadConfigs((List<Configuration>)configs, CarverTemplate::new), main)).close().open("palettes", ".yml").then(configs -> ConfigPack.buildAll(new PaletteFactory(), this.paletteRegistry, this.abstractConfigLoader.loadConfigs((List<Configuration>)configs, PaletteTemplate::new), main)).close().open("ores", ".yml").then(configs -> ConfigPack.buildAll(new OreFactory(), this.oreRegistry, this.abstractConfigLoader.loadConfigs((List<Configuration>)configs, OreTemplate::new), main)).close().open("structures/trees", ".yml").then(configs -> ConfigPack.buildAll(new TreeFactory(), this.treeRegistry, this.abstractConfigLoader.loadConfigs((List<Configuration>)configs, TreeTemplate::new), main)).close().open("structures/structures", ".yml").then(configs -> ConfigPack.buildAll(new StructureFactory(), this.structureRegistry, this.abstractConfigLoader.loadConfigs((List<Configuration>)configs, StructureTemplate::new), main)).close().open("flora", ".yml").then(configs -> ConfigPack.buildAll(new FloraFactory(), this.floraRegistry, this.abstractConfigLoader.loadConfigs((List<Configuration>)configs, FloraTemplate::new), main)).close().open("biomes", ".yml").then(configs -> ConfigPack.buildAll(new BiomeFactory(this), this.biomeRegistry, this.abstractConfigLoader.loadConfigs((List<Configuration>)configs, () -> new BiomeTemplate(this, main)), main)).close();
        main.getEventManager().callEvent(new ConfigPackPostLoadEvent(this, template -> this.selfLoader.load(template, this.configuration)));
        main.logger().info("Loaded config pack \"" + this.template.getID() + "\" v" + this.template.getVersion() + " by " + this.template.getAuthor() + " in " + (double)(System.nanoTime() - start) / 1000000.0 + "ms.");
    }

    public TerraStructure getStructure(String id) {
        return (TerraStructure)this.structureRegistry.get(id);
    }

    public Set<TerraStructure> getStructures() {
        return this.structureRegistry.entries();
    }

    public List<String> getStructureIDs() {
        return this.structureRegistry.entries().stream().map(terraStructure -> terraStructure.getTemplate().getID()).collect(Collectors.toList());
    }

    public ConfigPackTemplate getTemplate() {
        return this.template;
    }

    public Scope getVarScope() {
        return this.varScope;
    }

    @Override
    public void register(TypeRegistry registry) {
        registry.registerLoader((Type)((Object)Palette.class), this.paletteRegistry).registerLoader((Type)((Object)BiomeBuilder.class), this.biomeRegistry).registerLoader((Type)((Object)Flora.class), this.floraRegistry).registerLoader((Type)((Object)Ore.class), this.oreRegistry).registerLoader((Type)((Object)Tree.class), this.treeRegistry).registerLoader((Type)((Object)StructureScript.class), this.scriptRegistry).registerLoader((Type)((Object)TerraStructure.class), this.structureRegistry).registerLoader((Type)((Object)LootTable.class), this.lootRegistry).registerLoader((Type)((Object)UserDefinedCarver.class), this.carverRegistry).registerLoader((Type)((Object)BufferedImage.class), new BufferedImageLoader(this.loader)).registerLoader((Type)((Object)NoiseSeeded.class), new NoiseSamplerBuilderLoader(this.noiseRegistry)).registerLoader((Type)((Object)SingleBiomeProviderTemplate.class), SingleBiomeProviderTemplate::new).registerLoader((Type)((Object)BiomePipelineTemplate.class), () -> new BiomePipelineTemplate(this.main)).registerLoader((Type)((Object)ImageProviderTemplate.class), () -> new ImageProviderTemplate(this.biomeRegistry)).registerLoader((Type)((Object)ImageSamplerTemplate.class), () -> new ImageProviderTemplate(this.biomeRegistry));
    }

    public Set<UserDefinedCarver> getCarvers() {
        return this.carverRegistry.entries();
    }

    public BiomeProvider.BiomeProviderBuilder getBiomeProviderBuilder() {
        return this.biomeProviderBuilder;
    }

    public CheckedRegistry<StructureScript> getScriptRegistry() {
        return new CheckedRegistry<StructureScript>(this.scriptRegistry);
    }

    public CheckedRegistry<BiomeBuilder> getBiomeRegistry() {
        return new CheckedRegistry<BiomeBuilder>(this.biomeRegistry);
    }

    public CheckedRegistry<Tree> getTreeRegistry() {
        return new CheckedRegistry<Tree>(this.treeRegistry);
    }

    public CheckedRegistry<FunctionBuilder<?>> getFunctionRegistry() {
        return new CheckedRegistry(this.functionRegistry);
    }

    public CheckedRegistry<Supplier<ObjectTemplate<NoiseSeeded>>> getNormalizerRegistry() {
        return new CheckedRegistry<Supplier<ObjectTemplate<NoiseSeeded>>>(this.noiseRegistry);
    }

    public CheckedRegistry<UserDefinedCarver> getCarverRegistry() {
        return new CheckedRegistry<UserDefinedCarver>(this.carverRegistry);
    }

    public CheckedRegistry<Flora> getFloraRegistry() {
        return new CheckedRegistry<Flora>(this.floraRegistry);
    }

    public CheckedRegistry<LootTable> getLootRegistry() {
        return new CheckedRegistry<LootTable>(this.lootRegistry);
    }

    public CheckedRegistry<Ore> getOreRegistry() {
        return new CheckedRegistry<Ore>(this.oreRegistry);
    }

    public CheckedRegistry<Palette<BlockData>> getPaletteRegistry() {
        return new CheckedRegistry<Palette<BlockData>>(this.paletteRegistry);
    }

    public CheckedRegistry<TerraStructure> getStructureRegistry() {
        return new CheckedRegistry<TerraStructure>(this.structureRegistry);
    }

    public WorldConfig toWorldConfig(TerraWorld world) {
        return new WorldConfig(world, this, this.main);
    }
}

