/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config.templates;

import com.dfsek.paralithic.eval.parser.Parser;
import com.dfsek.paralithic.eval.parser.Scope;
import com.dfsek.paralithic.eval.tokenizer.ParseException;
import com.dfsek.tectonic.annotations.Abstractable;
import com.dfsek.tectonic.annotations.Default;
import com.dfsek.tectonic.annotations.Value;
import com.dfsek.tectonic.config.ValidatedConfigTemplate;
import com.dfsek.tectonic.exception.ValidationException;
import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.math.noise.samplers.noise.ConstantSampler;
import com.dfsek.terra.api.math.paralithic.BlankFunction;
import com.dfsek.terra.api.math.paralithic.defined.UserDefinedFunction;
import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.platform.block.BlockType;
import com.dfsek.terra.api.platform.world.Biome;
import com.dfsek.terra.api.util.GlueList;
import com.dfsek.terra.api.util.collections.ProbabilityCollection;
import com.dfsek.terra.api.util.seeded.NoiseSeeded;
import com.dfsek.terra.api.world.palette.Palette;
import com.dfsek.terra.api.world.palette.SinglePalette;
import com.dfsek.terra.api.world.palette.holder.PaletteHolder;
import com.dfsek.terra.carving.UserDefinedCarver;
import com.dfsek.terra.config.loaders.config.function.FunctionTemplate;
import com.dfsek.terra.config.pack.ConfigPack;
import com.dfsek.terra.config.templates.AbstractableTemplate;
import com.dfsek.terra.world.population.items.TerraStructure;
import com.dfsek.terra.world.population.items.flora.FloraLayer;
import com.dfsek.terra.world.population.items.ores.OreHolder;
import com.dfsek.terra.world.population.items.tree.TreeLayer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BiomeTemplate
extends AbstractableTemplate
implements ValidatedConfigTemplate {
    private final ConfigPack pack;
    @Value(value="id")
    private String id;
    @Value(value="extends")
    @Default
    private String extend = null;
    @Value(value="variables")
    @Abstractable
    @Default
    private Map<String, Double> variables = new HashMap<String, Double>();
    @Value(value="functions")
    @Default
    @Abstractable
    private LinkedHashMap<String, FunctionTemplate> functions = new LinkedHashMap();
    @Value(value="beta.carving.equation")
    @Abstractable
    @Default
    private String carvingEquation = "0";
    @Value(value="palette")
    @Abstractable
    private PaletteHolder palette;
    @Value(value="slant.palette")
    @Abstractable
    @Default
    private PaletteHolder slantPalette = null;
    @Value(value="vanilla")
    @Abstractable
    private ProbabilityCollection<Biome> vanilla;
    @Value(value="biome-noise")
    @Default
    @Abstractable
    private NoiseSeeded biomeNoise;
    @Value(value="blend.distance")
    @Abstractable
    @Default
    private int blendDistance = 3;
    @Value(value="blend.weight")
    @Abstractable
    @Default
    private double blendWeight = 1.0;
    @Value(value="blend.step")
    @Abstractable
    @Default
    private int blendStep = 4;
    @Value(value="erode")
    @Abstractable
    @Default
    private String erode = null;
    @Value(value="structures")
    @Abstractable
    @Default
    private List<TerraStructure> structures = new GlueList<TerraStructure>();
    @Value(value="noise-equation")
    @Abstractable
    private String noiseEquation;
    @Value(value="ores")
    @Abstractable
    @Default
    private OreHolder oreHolder = new OreHolder();
    @Value(value="ocean.level")
    @Abstractable
    @Default
    private int seaLevel = 62;
    @Value(value="ocean.palette")
    @Abstractable
    @Default
    private Palette<BlockData> oceanPalette;
    @Value(value="elevation.equation")
    @Default
    @Abstractable
    private String elevationEquation = null;
    @Value(value="elevation.weight")
    @Default
    @Abstractable
    private double elevationWeight = 1.0;
    @Value(value="flora")
    @Abstractable
    @Default
    private List<FloraLayer> flora = new GlueList<FloraLayer>();
    @Value(value="trees")
    @Abstractable
    @Default
    private List<TreeLayer> trees = new GlueList<TreeLayer>();
    @Value(value="slabs.enable")
    @Abstractable
    @Default
    private boolean doSlabs = false;
    @Value(value="slabs.threshold")
    @Abstractable
    @Default
    private double slabThreshold = 0.0075;
    @Value(value="slabs.palettes")
    @Abstractable
    @Default
    private Map<BlockType, Palette<BlockData>> slabPalettes;
    @Value(value="slabs.stair-palettes")
    @Abstractable
    @Default
    private Map<BlockType, Palette<BlockData>> stairPalettes;
    @Value(value="slant.threshold")
    @Abstractable
    @Default
    private double slantThreshold = 0.1;
    @Value(value="interpolate-elevation")
    @Abstractable
    @Default
    private boolean interpolateElevation = true;
    @Value(value="color")
    @Default
    private int color = 0;
    @Value(value="tags")
    @Default
    @Abstractable
    private Set<String> tags = new HashSet<String>();
    @Value(value="carving")
    @Abstractable
    @Default
    private Map<UserDefinedCarver, Integer> carvers = new HashMap<UserDefinedCarver, Integer>();
    @Value(value="colors")
    @Abstractable
    @Default
    private Map<String, Integer> colors = new HashMap<String, Integer>();

    public Set<String> getTags() {
        return this.tags;
    }

    public Map<String, Integer> getColors() {
        return this.colors;
    }

    public Map<UserDefinedCarver, Integer> getCarvers() {
        return this.carvers;
    }

    public Map<String, FunctionTemplate> getFunctions() {
        return this.functions;
    }

    public double getBlendWeight() {
        return this.blendWeight;
    }

    public int getColor() {
        return this.color;
    }

    public int getBlendDistance() {
        return this.blendDistance;
    }

    public boolean interpolateElevation() {
        return this.interpolateElevation;
    }

    public String getExtend() {
        return this.extend;
    }

    public double getSlantThreshold() {
        return this.slantThreshold;
    }

    public double getSlabThreshold() {
        return this.slabThreshold;
    }

    public List<FloraLayer> getFlora() {
        return this.flora;
    }

    public boolean doSlabs() {
        return this.doSlabs;
    }

    public Map<BlockType, Palette<BlockData>> getSlabPalettes() {
        return this.slabPalettes;
    }

    public Map<BlockType, Palette<BlockData>> getStairPalettes() {
        return this.stairPalettes;
    }

    public BiomeTemplate(ConfigPack pack, TerraPlugin main) {
        this.pack = pack;
        this.biomeNoise = new NoiseSeeded(){

            @Override
            public NoiseSampler apply(Long seed) {
                return new ConstantSampler(0.0);
            }

            @Override
            public int getDimensions() {
                return 2;
            }
        };
        this.oceanPalette = new SinglePalette<BlockData>(main.getWorldHandle().createBlockData("minecraft:water"));
    }

    public NoiseSeeded getBiomeNoise() {
        return this.biomeNoise;
    }

    public String getElevationEquation() {
        return this.elevationEquation;
    }

    public String getCarvingEquation() {
        return this.carvingEquation;
    }

    public ConfigPack getPack() {
        return this.pack;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public Palette<BlockData> getOceanPalette() {
        return this.oceanPalette;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public PaletteHolder getPalette() {
        return this.palette;
    }

    public List<TreeLayer> getTrees() {
        return this.trees;
    }

    public PaletteHolder getSlantPalette() {
        return this.slantPalette;
    }

    public ProbabilityCollection<Biome> getVanilla() {
        return this.vanilla;
    }

    public String getErode() {
        return this.erode;
    }

    public List<TerraStructure> getStructures() {
        return this.structures;
    }

    public String getNoiseEquation() {
        return this.noiseEquation;
    }

    public OreHolder getOreHolder() {
        return this.oreHolder;
    }

    public double getElevationWeight() {
        return this.elevationWeight;
    }

    public int getBlendStep() {
        return this.blendStep;
    }

    public Map<String, Double> getVariables() {
        return this.variables;
    }

    @Override
    public boolean validate() throws ValidationException {
        this.color |= 0xFF000000;
        Parser tester = new Parser();
        Scope testScope = new Scope().withParent(this.pack.getVarScope());
        this.variables.forEach(testScope::create);
        testScope.addInvocationVariable("x");
        testScope.addInvocationVariable("y");
        testScope.addInvocationVariable("z");
        this.pack.getTemplate().getNoiseBuilderMap().forEach((id, builder) -> tester.registerFunction((String)id, new BlankFunction(builder.getDimensions())));
        LinkedHashMap<String, FunctionTemplate> testFunctions = new LinkedHashMap<String, FunctionTemplate>(this.pack.getTemplate().getFunctions());
        testFunctions.putAll(this.functions);
        for (Map.Entry entry : testFunctions.entrySet()) {
            try {
                tester.registerFunction((String)entry.getKey(), UserDefinedFunction.newInstance((FunctionTemplate)entry.getValue(), tester, testScope));
            }
            catch (ParseException e) {
                throw new ValidationException("Invalid function: ", e);
            }
        }
        try {
            tester.parse(this.noiseEquation, testScope);
        }
        catch (ParseException e) {
            throw new ValidationException("Invalid noise equation: ", e);
        }
        try {
            tester.parse(this.carvingEquation, testScope);
        }
        catch (ParseException e) {
            throw new ValidationException("Invalid carving equation: ", e);
        }
        try {
            if (this.elevationEquation != null) {
                tester.parse(this.elevationEquation, testScope);
            }
        }
        catch (ParseException e) {
            throw new ValidationException("Invalid elevation equation: ", e);
        }
        return true;
    }
}

