/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.forge;

import com.dfsek.terra.api.math.vector.Vector3;
import com.dfsek.terra.api.platform.block.Block;
import com.dfsek.terra.api.platform.block.BlockFace;
import com.dfsek.terra.api.platform.block.state.BlockState;
import com.dfsek.terra.api.platform.block.state.Container;
import com.dfsek.terra.api.platform.block.state.MobSpawner;
import com.dfsek.terra.api.platform.block.state.Sign;
import com.dfsek.terra.forge.block.ForgeBlockData;
import com.dfsek.terra.forge.block.data.ForgeDirectional;
import com.dfsek.terra.forge.block.data.ForgeMultipleFacing;
import com.dfsek.terra.forge.block.data.ForgeOrientable;
import com.dfsek.terra.forge.block.data.ForgeRotatable;
import com.dfsek.terra.forge.block.data.ForgeSlab;
import com.dfsek.terra.forge.block.data.ForgeStairs;
import com.dfsek.terra.forge.block.data.ForgeWaterlogged;
import java.util.Arrays;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public final class ForgeAdapter {
    public static BlockPos adapt(Vector3 v) {
        return new BlockPos(v.getBlockX(), v.getBlockY(), v.getBlockZ());
    }

    public static Vector3 adapt(BlockPos pos) {
        return new Vector3(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static ForgeBlockData adapt(net.minecraft.block.BlockState state) {
        if (state.func_235901_b_((Property)BlockStateProperties.field_208146_au)) {
            return new ForgeStairs(state);
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208145_at)) {
            return new ForgeSlab(state);
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208148_A)) {
            return new ForgeOrientable(state, (EnumProperty<Direction.Axis>)BlockStateProperties.field_208148_A);
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208199_z)) {
            return new ForgeOrientable(state, (EnumProperty<Direction.Axis>)BlockStateProperties.field_208199_z);
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208138_am)) {
            return new ForgeRotatable(state);
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
            return new ForgeDirectional(state, BlockStateProperties.field_208155_H);
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208156_I)) {
            return new ForgeDirectional(state, BlockStateProperties.field_208156_I);
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
            return new ForgeDirectional(state, BlockStateProperties.field_208157_J);
        }
        if (state.func_235904_r_().containsAll(Arrays.asList(BlockStateProperties.field_208151_D, BlockStateProperties.field_208153_F, BlockStateProperties.field_208152_E, BlockStateProperties.field_208154_G))) {
            return new ForgeMultipleFacing(state);
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
            return new ForgeWaterlogged(state);
        }
        return new ForgeBlockData(state);
    }

    public static BlockState adapt(Block block) {
        IWorld worldAccess = (IWorld)block.getLocation().getWorld();
        TileEntity entity = worldAccess.func_175625_s(ForgeAdapter.adapt(block.getLocation().toVector()));
        if (entity instanceof SignTileEntity) {
            return (Sign)entity;
        }
        if (entity instanceof MobSpawnerTileEntity) {
            return (MobSpawner)entity;
        }
        if (entity instanceof LockableLootTileEntity) {
            return (Container)entity;
        }
        return null;
    }

    public static Direction adapt(BlockFace face) {
        switch (face) {
            case NORTH: {
                return Direction.NORTH;
            }
            case WEST: {
                return Direction.WEST;
            }
            case SOUTH: {
                return Direction.SOUTH;
            }
            case EAST: {
                return Direction.EAST;
            }
            case UP: {
                return Direction.UP;
            }
            case DOWN: {
                return Direction.DOWN;
            }
        }
        throw new IllegalArgumentException("Illegal direction: " + (Object)((Object)face));
    }
}

