/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.forge;

import com.dfsek.terra.api.util.generic.pair.Pair;
import com.dfsek.terra.config.builder.BiomeBuilder;
import com.dfsek.terra.config.pack.ConfigPack;
import com.dfsek.terra.config.templates.BiomeTemplate;
import com.dfsek.terra.forge.TerraForgePlugin;
import com.dfsek.terra.forge.config.PostLoadCompatibilityOptions;
import com.dfsek.terra.forge.config.PreLoadCompatibilityOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;

public final class ForgeUtil {
    public static String createBiomeID(ConfigPack pack, String biomeID) {
        return pack.getTemplate().getID().toLowerCase() + "/" + biomeID.toLowerCase(Locale.ROOT);
    }

    public static Biome createBiome(BiomeBuilder biome, ConfigPack pack, TerraForgePlugin.ForgeAddon forgeAddon) {
        BiomeTemplate template = biome.getTemplate();
        Map<String, Integer> colors = template.getColors();
        Biome vanilla = (Biome)new ArrayList<com.dfsek.terra.api.platform.world.Biome>(biome.getVanillaBiomes().getContents()).get(0).getHandle();
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder();
        generationSettings.func_242519_a(vanilla.func_242440_e().func_242500_d());
        generationSettings.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, TerraForgePlugin.POPULATOR_CONFIGURED_FEATURE);
        if (pack.getTemplate().vanillaCaves()) {
            for (GenerationStage.Carving carver : GenerationStage.Carving.values()) {
                for (Supplier configuredCarverSupplier : vanilla.func_242440_e().func_242489_a(carver)) {
                    generationSettings.func_242512_a(carver, (ConfiguredCarver)configuredCarverSupplier.get());
                }
            }
        }
        Pair<PreLoadCompatibilityOptions, PostLoadCompatibilityOptions> pair = forgeAddon.getTemplates().get(pack);
        PreLoadCompatibilityOptions compatibilityOptions = pair.getLeft();
        PostLoadCompatibilityOptions postLoadCompatibilityOptions = pair.getRight();
        TerraForgePlugin.getInstance().getDebugLogger().info("Injecting Vanilla structures and features into Terra biome " + biome.getTemplate().getID());
        for (Object structureFeature : vanilla.func_242440_e().func_242487_a()) {
            ResourceLocation key = WorldGenRegistries.field_243654_f.func_177774_c((Object)((StructureFeature)structureFeature.get()));
            if (compatibilityOptions.getExcludedBiomeStructures().contains(key) || postLoadCompatibilityOptions.getExcludedPerBiomeStructures().getOrDefault(biome, Collections.emptySet()).contains(key)) continue;
            generationSettings.func_242516_a((StructureFeature)structureFeature.get());
            TerraForgePlugin.getInstance().getDebugLogger().info("Injected structure " + key);
        }
        if (compatibilityOptions.doBiomeInjection()) {
            for (int step = 0; step < vanilla.func_242440_e().func_242498_c().size(); ++step) {
                for (Supplier featureSupplier : (List)vanilla.func_242440_e().func_242498_c().get(step)) {
                    ResourceLocation key = WorldGenRegistries.field_243653_e.func_177774_c((Object)((ConfiguredFeature)featureSupplier.get()));
                    if (compatibilityOptions.getExcludedBiomeFeatures().contains(key) || postLoadCompatibilityOptions.getExcludedPerBiomeFeatures().getOrDefault(biome, Collections.emptySet()).contains(key)) continue;
                    generationSettings.func_242510_a(step, featureSupplier);
                    TerraForgePlugin.getInstance().getDebugLogger().info("Injected feature " + key + " at stage " + step);
                }
            }
        }
        BiomeAmbience vanillaEffects = vanilla.func_235089_q_();
        BiomeAmbience.Builder effects = new BiomeAmbience.Builder().func_235246_b_(colors.getOrDefault("water", vanillaEffects.func_235216_b_()).intValue()).func_235248_c_(colors.getOrDefault("water-fog", vanillaEffects.func_235218_c_()).intValue()).func_235239_a_(colors.getOrDefault("fog", vanillaEffects.func_235213_a_()).intValue()).func_242539_d(colors.getOrDefault("sky", vanillaEffects.func_242527_d()).intValue()).func_242537_a(vanillaEffects.func_242531_g());
        if (colors.containsKey("grass")) {
            effects.func_242541_f(colors.get("grass").intValue());
        } else {
            vanillaEffects.func_242529_f().ifPresent(arg_0 -> ((BiomeAmbience.Builder)effects).func_242541_f(arg_0));
        }
        if (colors.containsKey("foliage")) {
            effects.func_242540_e(colors.get("foliage").intValue());
        } else {
            vanillaEffects.func_242528_e().ifPresent(arg_0 -> ((BiomeAmbience.Builder)effects).func_242540_e(arg_0));
        }
        return (Biome)new Biome.Builder().func_205415_a(vanilla.func_201851_b()).func_205419_a(vanilla.func_201856_r()).func_205421_a(vanilla.func_185355_j()).func_205420_b(vanilla.func_185360_m()).func_205414_c(vanilla.func_242445_k()).func_205417_d(vanilla.func_76727_i()).func_235097_a_(effects.func_235238_a_()).func_242458_a(vanilla.func_242433_b()).func_242457_a(generationSettings.func_242508_a()).func_242455_a().setRegistryName("terra", ForgeUtil.createBiomeID(template.getPack(), template.getID()));
    }
}

