/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.forge;

import com.dfsek.tectonic.exception.ConfigException;
import com.dfsek.tectonic.exception.LoadException;
import com.dfsek.tectonic.loading.TypeRegistry;
import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.addons.TerraAddon;
import com.dfsek.terra.api.addons.annotations.Addon;
import com.dfsek.terra.api.addons.annotations.Author;
import com.dfsek.terra.api.addons.annotations.Version;
import com.dfsek.terra.api.command.CommandManager;
import com.dfsek.terra.api.command.TerraCommandManager;
import com.dfsek.terra.api.command.exception.MalformedCommandException;
import com.dfsek.terra.api.event.EventListener;
import com.dfsek.terra.api.event.EventManager;
import com.dfsek.terra.api.event.TerraEventManager;
import com.dfsek.terra.api.event.annotations.Global;
import com.dfsek.terra.api.event.annotations.Priority;
import com.dfsek.terra.api.event.events.config.ConfigPackPostLoadEvent;
import com.dfsek.terra.api.event.events.config.ConfigPackPreLoadEvent;
import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.platform.handle.ItemHandle;
import com.dfsek.terra.api.platform.handle.WorldHandle;
import com.dfsek.terra.api.platform.world.Tree;
import com.dfsek.terra.api.platform.world.World;
import com.dfsek.terra.api.registry.CheckedRegistry;
import com.dfsek.terra.api.registry.LockedRegistry;
import com.dfsek.terra.api.transform.Transformer;
import com.dfsek.terra.api.transform.Validator;
import com.dfsek.terra.api.util.JarUtil;
import com.dfsek.terra.api.util.generic.pair.Pair;
import com.dfsek.terra.api.util.logging.DebugLogger;
import com.dfsek.terra.api.util.logging.Logger;
import com.dfsek.terra.commands.CommandUtil;
import com.dfsek.terra.config.GenericLoaders;
import com.dfsek.terra.config.PluginConfig;
import com.dfsek.terra.config.lang.LangUtil;
import com.dfsek.terra.config.lang.Language;
import com.dfsek.terra.config.pack.ConfigPack;
import com.dfsek.terra.forge.ForgeUtil;
import com.dfsek.terra.forge.config.PostLoadCompatibilityOptions;
import com.dfsek.terra.forge.config.PreLoadCompatibilityOptions;
import com.dfsek.terra.forge.generation.ForgeChunkGeneratorWrapper;
import com.dfsek.terra.forge.generation.PopulatorFeature;
import com.dfsek.terra.forge.generation.TerraBiomeSource;
import com.dfsek.terra.forge.handle.ForgeItemHandle;
import com.dfsek.terra.forge.handle.ForgeWorldHandle;
import com.dfsek.terra.lib.commons.io.FileUtils;
import com.dfsek.terra.profiler.Profiler;
import com.dfsek.terra.profiler.ProfilerImpl;
import com.dfsek.terra.registry.exception.DuplicateEntryException;
import com.dfsek.terra.registry.master.AddonRegistry;
import com.dfsek.terra.registry.master.ConfigRegistry;
import com.dfsek.terra.world.TerraWorld;
import com.mojang.serialization.Codec;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.DecoratedPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;

@Mod(value="terra")
@Mod.EventBusSubscriber(modid="terra", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TerraForgePlugin
implements TerraPlugin {
    public static final PopulatorFeature POPULATOR_FEATURE = (PopulatorFeature)new PopulatorFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_).setRegistryName("terra", "terra");
    public static final ConfiguredFeature<?, ?> POPULATOR_CONFIGURED_FEATURE = POPULATOR_FEATURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(DecoratedPlacement.field_215022_h.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_236556_b_));
    private static TerraForgePlugin INSTANCE;
    private final Map<DimensionType, Pair<ServerWorld, TerraWorld>> worldMap = new HashMap<DimensionType, Pair<ServerWorld, TerraWorld>>();
    private final EventManager eventManager = new TerraEventManager(this);
    private final GenericLoaders genericLoaders = new GenericLoaders(this);
    private final Profiler profiler = new ProfilerImpl();
    private final CommandManager manager = new TerraCommandManager(this);
    private final Logger logger = new Logger(){
        private final org.apache.logging.log4j.Logger logger = LogManager.getLogger();

        @Override
        public void info(String message) {
            this.logger.info(message);
        }

        @Override
        public void warning(String message) {
            this.logger.warn(message);
        }

        @Override
        public void severe(String message) {
            this.logger.error(message);
        }
    };
    private final DebugLogger debugLogger = new DebugLogger(this.logger);
    private final ItemHandle itemHandle = new ForgeItemHandle();
    private final WorldHandle worldHandle = new ForgeWorldHandle();
    private final ConfigRegistry registry = new ConfigRegistry();
    private final CheckedRegistry<ConfigPack> checkedRegistry = new CheckedRegistry<ConfigPack>(this.registry);
    private final ForgeAddon addon = new ForgeAddon(this);
    private final AddonRegistry addonRegistry = new AddonRegistry(this.addon, this);
    private final LockedRegistry<TerraAddon> addonLockedRegistry = new LockedRegistry<TerraAddon>(this.addonRegistry);
    private final PluginConfig config = new PluginConfig();
    private final Transformer<String, Biome> biomeFixer = new Transformer.Builder<String, Biome>().addTransform(id -> (Biome)ForgeRegistries.BIOMES.getValue(ResourceLocation.func_208304_a((String)id)), Validator.notNull()).addTransform(id -> (Biome)ForgeRegistries.BIOMES.getValue(ResourceLocation.func_208304_a((String)("minecraft:" + id.toLowerCase()))), Validator.notNull()).build();
    private final File dataFolder;

    public TerraForgePlugin() {
        if (INSTANCE != null) {
            throw new IllegalStateException("Only one TerraPlugin instance may exist.");
        }
        INSTANCE = this;
        this.dataFolder = Paths.get("config", "Terra").toFile();
        this.saveDefaultConfig();
        this.config.load(this);
        this.debugLogger.setDebug(this.config.isDebug());
        LangUtil.load(this.config.getLanguage(), this);
        try {
            CommandUtil.registerAll(this.manager);
        }
        catch (MalformedCommandException e) {
            e.printStackTrace();
        }
    }

    public static TerraForgePlugin getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void setupListener(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Registry.func_218325_a((Registry)Registry.field_239689_aA_, (String)"terra:biome", TerraBiomeSource.CODEC);
            Registry.func_218325_a((Registry)Registry.field_239690_aB_, (String)"terra:generator", ForgeChunkGeneratorWrapper.CODEC);
        });
    }

    public void init() {
        this.logger.info("Initializing Terra...");
        if (!this.addonRegistry.loadAll()) {
            throw new IllegalStateException("Failed to load addons. Please correct addon installations to continue.");
        }
        this.logger.info("Loaded addons.");
        this.registry.loadAll(this);
        this.logger.info("Loaded packs.");
        ((ForgeRegistry)ForgeRegistries.BIOMES).unfreeze();
        this.getConfigRegistry().forEach(pack -> pack.getBiomeRegistry().forEach((id, biome) -> ForgeRegistries.BIOMES.register((IForgeRegistryEntry)ForgeUtil.createBiome(biome, pack, this.addon))));
        ((ForgeRegistry)ForgeRegistries.BIOMES).freeze();
    }

    @Override
    public WorldHandle getWorldHandle() {
        return this.worldHandle;
    }

    @Override
    public TerraWorld getWorld(World world) {
        return this.getWorld(((IWorld)world).func_230315_m_());
    }

    public TerraWorld getWorld(DimensionType type) {
        TerraWorld world = this.worldMap.get(type).getRight();
        if (world == null) {
            throw new IllegalArgumentException("No world exists with dimension type " + type);
        }
        return world;
    }

    @Override
    public JarFile getModJar() throws URISyntaxException, IOException {
        File modsDir = new File("./mods");
        if (!modsDir.exists()) {
            return JarUtil.getJarFile();
        }
        for (File file : Objects.requireNonNull(modsDir.listFiles((dir, name) -> name.endsWith(".jar")))) {
            try (ZipFile zipFile = new ZipFile(file);){
                if (zipFile.getEntry(com.dfsek.terra.lib.asm.Type.getInternalName(TerraPlugin.class) + ".class") == null) continue;
                JarFile jarFile = new JarFile(file);
                return jarFile;
            }
        }
        return JarUtil.getJarFile();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public PluginConfig getTerraConfig() {
        return this.config;
    }

    @Override
    public File getDataFolder() {
        return this.dataFolder;
    }

    @Override
    public boolean isDebug() {
        return this.config.isDebug();
    }

    @Override
    public Language getLanguage() {
        return LangUtil.getLanguage();
    }

    @Override
    public CheckedRegistry<ConfigPack> getConfigRegistry() {
        return this.checkedRegistry;
    }

    @Override
    public LockedRegistry<TerraAddon> getAddons() {
        return this.addonLockedRegistry;
    }

    @Override
    public boolean reload() {
        this.config.load(this);
        LangUtil.load(this.config.getLanguage(), this);
        boolean succeed = this.registry.loadAll(this);
        this.worldMap.forEach((seed, pair) -> {
            ((TerraWorld)pair.getRight()).getConfig().getSamplerCache().clear();
            String packID = ((TerraWorld)pair.getRight()).getConfig().getTemplate().getID();
            pair.setRight(new TerraWorld(((TerraWorld)pair.getRight()).getWorld(), (ConfigPack)this.registry.get(packID), this));
        });
        return succeed;
    }

    @Override
    public ItemHandle getItemHandle() {
        return this.itemHandle;
    }

    @Override
    public void saveDefaultConfig() {
        try (InputStream stream = this.getClass().getResourceAsStream("/config.yml");){
            File configFile = new File(this.getDataFolder(), "config.yml");
            if (!configFile.exists()) {
                FileUtils.copyInputStreamToFile(stream, configFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String platformName() {
        return "Forge";
    }

    @Override
    public DebugLogger getDebugLogger() {
        return this.debugLogger;
    }

    @Override
    public void register(TypeRegistry registry) {
        this.genericLoaders.register(registry);
        registry.registerLoader((Type)((Object)BlockData.class), (t, o, l) -> this.worldHandle.createBlockData((String)o)).registerLoader((Type)((Object)com.dfsek.terra.api.platform.world.Biome.class), (t, o, l) -> this.biomeFixer.translate((String)o)).registerLoader((Type)((Object)ResourceLocation.class), (t, o, l) -> {
            ResourceLocation identifier = ResourceLocation.func_208304_a((String)((String)o));
            if (identifier == null) {
                throw new LoadException("Invalid identifier: " + o);
            }
            return identifier;
        });
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public Profiler getProfiler() {
        return this.profiler;
    }

    public CommandManager getManager() {
        return this.manager;
    }

    public Map<DimensionType, Pair<ServerWorld, TerraWorld>> getWorldMap() {
        return this.worldMap;
    }

    @Addon(value="Terra-Forge")
    @Author(value="Terra")
    @Version(value="1.0.0")
    public static final class ForgeAddon
    extends TerraAddon
    implements EventListener {
        private final Map<ConfigPack, Pair<PreLoadCompatibilityOptions, PostLoadCompatibilityOptions>> templates = new HashMap<ConfigPack, Pair<PreLoadCompatibilityOptions, PostLoadCompatibilityOptions>>();
        private final TerraPlugin main;

        private ForgeAddon(TerraPlugin main) {
            this.main = main;
        }

        @Override
        public void initialize() {
            this.main.getEventManager().registerListener(this, this);
        }

        @Priority(value=-2147483648)
        @Global
        public void injectTrees(ConfigPackPreLoadEvent event) {
            CheckedRegistry<Tree> treeRegistry = event.getPack().getTreeRegistry();
            this.injectTree(treeRegistry, "BROWN_MUSHROOM", Features.field_243860_bF);
            this.injectTree(treeRegistry, "RED_MUSHROOM", Features.field_243861_bG);
            this.injectTree(treeRegistry, "JUNGLE", Features.field_243871_bQ);
            this.injectTree(treeRegistry, "JUNGLE_COCOA", Features.field_243868_bN);
            this.injectTree(treeRegistry, "LARGE_OAK", Features.field_243869_bO);
            this.injectTree(treeRegistry, "LARGE_SPRUCE", Features.field_243867_bM);
            this.injectTree(treeRegistry, "SMALL_JUNGLE", Features.field_243868_bN);
            this.injectTree(treeRegistry, "SWAMP_OAK", Features.field_243875_bU);
            this.injectTree(treeRegistry, "TALL_BIRCH", Features.field_243940_cw);
            this.injectTree(treeRegistry, "ACACIA", Features.field_243865_bK);
            this.injectTree(treeRegistry, "BIRCH", Features.field_243864_bJ);
            this.injectTree(treeRegistry, "DARK_OAK", Features.field_243863_bI);
            this.injectTree(treeRegistry, "OAK", Features.field_243862_bH);
            this.injectTree(treeRegistry, "CHORUS_PLANT", Features.field_243944_d);
            this.injectTree(treeRegistry, "SPRUCE", Features.field_243866_bL);
            this.injectTree(treeRegistry, "JUNGLE_BUSH", Features.field_243876_bV);
            this.injectTree(treeRegistry, "MEGA_SPRUCE", Features.field_243872_bR);
            this.injectTree(treeRegistry, "CRIMSON_FUNGUS", Features.field_243856_bB);
            this.injectTree(treeRegistry, "WARPED_FUNGUS", Features.field_243858_bD);
            PreLoadCompatibilityOptions template = new PreLoadCompatibilityOptions();
            try {
                event.loadTemplate(template);
            }
            catch (ConfigException e) {
                e.printStackTrace();
            }
            if (template.doRegistryInjection()) {
                WorldGenRegistries.field_243653_e.func_239659_c_().forEach(entry -> {
                    if (!template.getExcludedRegistryFeatures().contains(((RegistryKey)entry.getKey()).getRegistryName())) {
                        try {
                            event.getPack().getTreeRegistry().add(((RegistryKey)entry.getKey()).getRegistryName().toString(), (Tree)entry.getValue());
                            this.main.getDebugLogger().info("Injected ConfiguredFeature " + ((RegistryKey)entry.getKey()).getRegistryName() + " as Tree: " + entry.getValue());
                        }
                        catch (DuplicateEntryException duplicateEntryException) {
                            // empty catch block
                        }
                    }
                });
            }
            this.templates.put(event.getPack(), Pair.of(template, null));
        }

        @Priority(value=0x7FFFFFFF)
        @Global
        public void createInjectionOptions(ConfigPackPostLoadEvent event) {
            PostLoadCompatibilityOptions template = new PostLoadCompatibilityOptions();
            try {
                event.loadTemplate(template);
            }
            catch (ConfigException e) {
                e.printStackTrace();
            }
            this.templates.get(event.getPack()).setRight(template);
        }

        private void injectTree(CheckedRegistry<Tree> registry, String id, ConfiguredFeature<?, ?> tree) {
            try {
                registry.add(id, (Tree)tree);
            }
            catch (DuplicateEntryException duplicateEntryException) {
                // empty catch block
            }
        }

        public Map<ConfigPack, Pair<PreLoadCompatibilityOptions, PostLoadCompatibilityOptions>> getTemplates() {
            return this.templates;
        }
    }
}

