/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.forge.block;

import com.dfsek.terra.api.math.vector.Location;
import com.dfsek.terra.api.platform.block.Block;
import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.platform.block.BlockFace;
import com.dfsek.terra.api.platform.block.BlockType;
import com.dfsek.terra.api.platform.block.state.BlockState;
import com.dfsek.terra.api.platform.world.World;
import com.dfsek.terra.forge.ForgeAdapter;
import com.dfsek.terra.forge.block.ForgeBlockData;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class ForgeBlock
implements Block {
    private final Handle delegate;

    public ForgeBlock(BlockPos position, IWorld worldAccess) {
        this.delegate = new Handle(position, worldAccess);
    }

    @Override
    public void setBlockData(BlockData data, boolean physics) {
        this.delegate.worldAccess.func_180501_a(this.delegate.position, ((ForgeBlockData)data).getHandle(), physics ? 3 : 1042);
        if (physics && ((ForgeBlockData)data).getHandle().func_177230_c() instanceof FlowingFluidBlock) {
            this.delegate.worldAccess.func_205219_F_().func_205360_a(this.delegate.position, (Object)((FlowingFluidBlock)((ForgeBlockData)data).getHandle().func_177230_c()).func_204507_t(((ForgeBlockData)data).getHandle()).getFluidState().func_206886_c(), 0);
        }
    }

    @Override
    public BlockData getBlockData() {
        return new ForgeBlockData(this.delegate.worldAccess.func_180495_p(this.delegate.position));
    }

    @Override
    public BlockState getState() {
        return ForgeAdapter.adapt(this);
    }

    @Override
    public Block getRelative(BlockFace face, int len) {
        BlockPos newPos = this.delegate.position.func_177982_a(face.getModX() * len, face.getModY() * len, face.getModZ() * len);
        return new ForgeBlock(newPos, this.delegate.worldAccess);
    }

    @Override
    public boolean isEmpty() {
        return this.getBlockData().isAir();
    }

    @Override
    public Location getLocation() {
        return ForgeAdapter.adapt(this.delegate.position).toLocation((World)this.delegate.worldAccess);
    }

    @Override
    public BlockType getType() {
        return this.getBlockData().getBlockType();
    }

    @Override
    public int getX() {
        return this.delegate.position.func_177958_n();
    }

    @Override
    public int getZ() {
        return this.delegate.position.func_177952_p();
    }

    @Override
    public int getY() {
        return this.delegate.position.func_177956_o();
    }

    @Override
    public boolean isPassable() {
        return this.isEmpty();
    }

    @Override
    public Handle getHandle() {
        return this.delegate;
    }

    public static final class Handle {
        private final BlockPos position;
        private final IWorld worldAccess;

        public Handle(BlockPos position, IWorld worldAccess) {
            this.position = position;
            this.worldAccess = worldAccess;
        }
    }
}

