/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.forge.block;

import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.platform.block.BlockType;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeBlockData
implements BlockData {
    private static final Function<Map.Entry<Property<?>, Comparable<?>>, String> PROPERTY_MAPPER = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            Property<?> property = entry.getKey();
            return property.func_177701_a() + "=" + this.getName(property, entry.getValue());
        }

        private <T extends Comparable<T>> String getName(Property<T> property, Comparable<?> comparable) {
            return property.func_177702_a(comparable);
        }
    };
    protected BlockState delegate;

    public ForgeBlockData(BlockState delegate) {
        this.delegate = delegate;
    }

    @Override
    public BlockType getBlockType() {
        return (BlockType)this.delegate.func_177230_c();
    }

    @Override
    public boolean matches(BlockData other) {
        return this.delegate.func_177230_c() == ((ForgeBlockData)other).delegate.func_177230_c();
    }

    @Override
    public BlockData clone() {
        try {
            return (ForgeBlockData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    @Override
    public String getAsString() {
        StringBuilder data = new StringBuilder(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.delegate.func_177230_c())).toString());
        if (!this.delegate.func_235904_r_().isEmpty()) {
            data.append('[');
            data.append(this.delegate.func_206871_b().entrySet().stream().map(PROPERTY_MAPPER).collect(Collectors.joining(",")));
            data.append(']');
        }
        return data.toString();
    }

    @Override
    public boolean isAir() {
        return this.delegate.func_196958_f();
    }

    @Override
    public boolean isStructureVoid() {
        return this.delegate.func_177230_c() == Blocks.field_189881_dj;
    }

    public BlockState getHandle() {
        return this.delegate;
    }
}

