/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.forge.generation;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.platform.world.World;
import com.dfsek.terra.api.platform.world.generator.ChunkData;
import com.dfsek.terra.api.platform.world.generator.GeneratorWrapper;
import com.dfsek.terra.api.util.FastRandom;
import com.dfsek.terra.api.world.biome.UserDefinedBiome;
import com.dfsek.terra.api.world.generation.TerraChunkGenerator;
import com.dfsek.terra.api.world.locate.AsyncStructureFinder;
import com.dfsek.terra.config.pack.ConfigPack;
import com.dfsek.terra.forge.ForgeAdapter;
import com.dfsek.terra.forge.TerraForgePlugin;
import com.dfsek.terra.forge.generation.TerraBiomeSource;
import com.dfsek.terra.lib.jafama.FastMath;
import com.dfsek.terra.world.TerraWorld;
import com.dfsek.terra.world.generation.generators.DefaultChunkGenerator3D;
import com.dfsek.terra.world.generation.math.samplers.Sampler;
import com.dfsek.terra.world.population.items.TerraStructure;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Blockreader;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeChunkGeneratorWrapper
extends ChunkGenerator
implements GeneratorWrapper {
    private final long seed;
    private final DefaultChunkGenerator3D delegate;
    private final TerraBiomeSource biomeSource;
    public static final Codec<ConfigPack> PACK_CODEC = RecordCodecBuilder.create(config -> config.group((App)Codec.STRING.fieldOf("pack").forGetter(pack -> pack.getTemplate().getID())).apply((Applicative)config, config.stable(TerraForgePlugin.getInstance().getConfigRegistry()::get)));
    public static final Codec<ForgeChunkGeneratorWrapper> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TerraBiomeSource.CODEC.fieldOf("biome_source").forGetter(generator -> generator.biomeSource), (App)Codec.LONG.fieldOf("seed").stable().forGetter(generator -> generator.seed), (App)PACK_CODEC.fieldOf("pack").stable().forGetter(generator -> generator.pack)).apply((Applicative)instance, instance.stable(ForgeChunkGeneratorWrapper::new)));
    private final ConfigPack pack;
    private DimensionType dimensionType;

    public ConfigPack getPack() {
        return this.pack;
    }

    public ForgeChunkGeneratorWrapper(TerraBiomeSource biomeSource, long seed, ConfigPack configPack) {
        super((BiomeProvider)biomeSource, new DimensionStructuresSettings(false));
        this.pack = configPack;
        this.delegate = new DefaultChunkGenerator3D(this.pack, TerraForgePlugin.getInstance());
        this.delegate.getMain().logger().info("Loading world with config pack " + this.pack.getTemplate().getID());
        this.biomeSource = biomeSource;
        this.seed = seed;
    }

    @NotNull
    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    @NotNull
    public ChunkGenerator func_230349_a_(long seed) {
        return new ForgeChunkGeneratorWrapper((TerraBiomeSource)this.biomeSource.func_230320_a_(seed), seed, this.pack);
    }

    public void func_225551_a_(@NotNull WorldGenRegion p_225551_1_, @NotNull IChunk p_225551_2_) {
    }

    @Nullable
    public BlockPos func_235956_a_(@NotNull ServerWorld world, @NotNull Structure<?> feature, @NotNull BlockPos center, int radius, boolean skipExistingChunks) {
        if (!this.pack.getTemplate().disableStructures()) {
            String name = Objects.requireNonNull(Registry.field_218361_B.func_177774_c(feature)).toString();
            TerraWorld terraWorld = TerraForgePlugin.getInstance().getWorld((World)world);
            TerraStructure located = this.pack.getStructure(this.pack.getTemplate().getLocatable().get(name));
            if (located != null) {
                CompletableFuture result = new CompletableFuture();
                AsyncStructureFinder finder = new AsyncStructureFinder(terraWorld.getBiomeProvider(), located, ForgeAdapter.adapt(center).toLocation((World)world), 0, 500, location -> result.complete(ForgeAdapter.adapt(location)), (TerraPlugin)TerraForgePlugin.getInstance());
                finder.run();
                try {
                    return (BlockPos)result.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return super.func_235956_a_(world, feature, center, radius, skipExistingChunks);
    }

    public boolean func_235952_a_(@NotNull ChunkPos p_235952_1_) {
        if (this.pack.getTemplate().vanillaStructures()) {
            return super.func_235952_a_(p_235952_1_);
        }
        return false;
    }

    public void func_242707_a(@NotNull DynamicRegistries dynamicRegistries, @NotNull StructureManager manager, @NotNull IChunk chunk, @NotNull TemplateManager templateManager, long p_242707_5_) {
        if (this.pack.getTemplate().vanillaStructures()) {
            super.func_242707_a(dynamicRegistries, manager, chunk, templateManager, p_242707_5_);
        }
    }

    public void func_230350_a_(long p_230350_1_, @NotNull BiomeManager biomeManager, @NotNull IChunk chunk, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStage.Carving carving) {
        if (this.pack.getTemplate().vanillaCaves()) {
            super.func_230350_a_(p_230350_1_, biomeManager, chunk, carving);
        }
    }

    public void func_230352_b_(@NotNull IWorld world, @NotNull StructureManager p_230352_2_, @NotNull IChunk chunk) {
        this.delegate.generateChunkData((World)world, new FastRandom(), chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b, (ChunkData)chunk);
    }

    public int func_222529_a(int x, int z, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Heightmap.Type p_222529_3_) {
        int height;
        TerraWorld world = TerraForgePlugin.getInstance().getWorld(this.dimensionType);
        Sampler sampler = world.getConfig().getSamplerCache().getChunk(FastMath.floorDiv(x, 16), FastMath.floorDiv(z, 16));
        int cx = FastMath.floorMod(x, 16);
        int cz = FastMath.floorMod(z, 16);
        for (height = world.getWorld().getMaxHeight(); height >= 0 && sampler.sample(cx, height - 1, cz) < 0.0; --height) {
        }
        return height;
    }

    @NotNull
    public IBlockReader func_230348_a_(int x, int z) {
        TerraWorld world = TerraForgePlugin.getInstance().getWorld(this.dimensionType);
        int height = this.func_222529_a(x, z, Heightmap.Type.WORLD_SURFACE);
        BlockState[] array = new BlockState[256];
        for (int y = 255; y >= 0; --y) {
            if (y > height) {
                if (y > ((UserDefinedBiome)world.getBiomeProvider().getBiome(x, z)).getConfig().getSeaLevel()) {
                    array[y] = Blocks.field_150350_a.func_176223_P();
                    continue;
                }
                array[y] = Blocks.field_150355_j.func_176223_P();
                continue;
            }
            array[y] = Blocks.field_150348_b.func_176223_P();
        }
        return new Blockreader(array);
    }

    public void func_230354_a_(WorldGenRegion region) {
        if (this.pack.getTemplate().vanillaMobs()) {
            int cx = region.func_201679_a();
            int cy = region.func_201680_b();
            Biome biome = region.func_226691_t_(new ChunkPos(cx, cy).func_206849_h());
            SharedSeedRandom chunkRandom = new SharedSeedRandom();
            chunkRandom.func_202424_a(region.func_72905_C(), cx << 4, cy << 4);
            WorldEntitySpawner.func_77191_a((IServerWorld)region, (Biome)biome, (int)cx, (int)cy, (Random)chunkRandom);
        }
    }

    @Override
    public TerraChunkGenerator getHandle() {
        return this.delegate;
    }

    public void setDimensionType(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }
}

