/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.forge.generation;

import com.dfsek.terra.api.world.biome.UserDefinedBiome;
import com.dfsek.terra.config.pack.ConfigPack;
import com.dfsek.terra.forge.ForgeUtil;
import com.dfsek.terra.forge.TerraForgePlugin;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import org.jetbrains.annotations.NotNull;

public class TerraBiomeSource
extends BiomeProvider {
    public static final Codec<ConfigPack> PACK_CODEC = RecordCodecBuilder.create(config -> config.group((App)Codec.STRING.fieldOf("pack").forGetter(pack -> pack.getTemplate().getID())).apply((Applicative)config, config.stable(TerraForgePlugin.getInstance().getConfigRegistry()::get)));
    public static final Codec<TerraBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(source -> source.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(source -> source.seed), (App)PACK_CODEC.fieldOf("pack").stable().forGetter(source -> source.pack)).apply((Applicative)instance, instance.stable(TerraBiomeSource::new)));
    private final Registry<Biome> biomeRegistry;
    private final long seed;
    private final com.dfsek.terra.api.world.biome.provider.BiomeProvider grid;
    private final ConfigPack pack;

    public TerraBiomeSource(Registry<Biome> biomes, long seed, ConfigPack pack) {
        super(biomes.func_201756_e().collect(Collectors.toList()));
        this.biomeRegistry = biomes;
        this.seed = seed;
        this.grid = pack.getBiomeProviderBuilder().build(seed);
        this.pack = pack;
    }

    @NotNull
    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    public @NotNull BiomeProvider func_230320_a_(long seed) {
        return new TerraBiomeSource(this.biomeRegistry, seed, this.pack);
    }

    @NotNull
    public Biome func_225526_b_(int biomeX, int biomeY, int biomeZ) {
        UserDefinedBiome biome = (UserDefinedBiome)this.grid.getBiome(biomeX << 2, biomeZ << 2);
        return Objects.requireNonNull((Biome)this.biomeRegistry.func_82594_a(new ResourceLocation("terra", ForgeUtil.createBiomeID(this.pack, biome.getID()))));
    }
}

