/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.forge.listener;

import com.dfsek.terra.api.command.CommandManager;
import com.dfsek.terra.api.command.exception.CommandException;
import com.dfsek.terra.api.platform.CommandSender;
import com.dfsek.terra.api.platform.entity.Entity;
import com.dfsek.terra.forge.TerraForgePlugin;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="terra", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeListener {
    private static final TerraForgePlugin INSTANCE = TerraForgePlugin.getInstance();

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        int max = INSTANCE.getManager().getMaxArgumentDepth();
        RequiredArgumentBuilder arg = RequiredArgumentBuilder.argument((String)("arg" + (max - 1)), (ArgumentType)StringArgumentType.word());
        for (int i = 0; i < max; ++i) {
            RequiredArgumentBuilder next = RequiredArgumentBuilder.argument((String)("arg" + (max - i - 1)), (ArgumentType)StringArgumentType.word());
            arg = (RequiredArgumentBuilder)next.then(ForgeListener.assemble((RequiredArgumentBuilder<CommandSource, String>)arg, INSTANCE.getManager()));
        }
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"terra").executes(context -> 1)).then(ForgeListener.assemble((RequiredArgumentBuilder<CommandSource, String>)arg, INSTANCE.getManager())));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"te").executes(context -> 1)).then(ForgeListener.assemble((RequiredArgumentBuilder<CommandSource, String>)arg, INSTANCE.getManager())));
    }

    public static RequiredArgumentBuilder<CommandSource, String> assemble(RequiredArgumentBuilder<CommandSource, String> in, CommandManager manager) {
        return (RequiredArgumentBuilder)in.suggests((context, builder) -> {
            List<String> args = ForgeListener.parseCommand(context.getInput());
            CommandSender sender = (CommandSender)context.getSource();
            try {
                sender = (Entity)((CommandSource)context.getSource()).func_197027_g();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            try {
                manager.tabComplete(args.remove(0), sender, args).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
            catch (CommandException e) {
                sender.sendMessage(e.getMessage());
            }
            return builder.buildFuture();
        }).executes(context -> {
            List<String> args = ForgeListener.parseCommand(context.getInput());
            try {
                CommandSender sender = (CommandSender)context.getSource();
                try {
                    sender = (Entity)((CommandSource)context.getSource()).func_197027_g();
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
                manager.execute(args.remove(0), sender, args);
            }
            catch (CommandException e) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent(e.getMessage()));
            }
            return 1;
        });
    }

    private static List<String> parseCommand(String command) {
        if (command.startsWith("/terra ")) {
            command = command.substring("/terra ".length());
        } else if (command.startsWith("/te ")) {
            command = command.substring("/te ".length());
        }
        ArrayList<String> c = new ArrayList<String>(Arrays.asList(command.split(" ")));
        if (command.endsWith(" ")) {
            c.add("");
        }
        return c;
    }
}

