/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.forge.mixin;

import com.dfsek.terra.config.pack.ConfigPack;
import com.dfsek.terra.forge.TerraForgePlugin;
import com.dfsek.terra.forge.generation.ForgeChunkGeneratorWrapper;
import com.dfsek.terra.forge.generation.TerraBiomeSource;
import com.google.common.base.MoreObjects;
import java.util.Properties;
import java.util.Random;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DimensionGeneratorSettings.class})
public abstract class DimensionGeneratorSettingsMixin {
    @Inject(method={"create(Lnet/minecraft/util/registry/DynamicRegistries;Ljava/util/Properties;)Lnet/minecraft/world/gen/settings/DimensionGeneratorSettings;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fromProperties(DynamicRegistries dynamicRegistries, Properties properties, CallbackInfoReturnable<DimensionGeneratorSettings> cir) {
        if (properties.get("level-type") == null) {
            return;
        }
        String prop = properties.get("level-type").toString().trim();
        if (prop.startsWith("Terra")) {
            String generate_structures;
            String seed = (String)MoreObjects.firstNonNull((Object)properties.get("level-seed"), (Object)"");
            long l = new Random().nextLong();
            if (!seed.isEmpty()) {
                try {
                    long m = Long.parseLong(seed);
                    if (m != 0L) {
                        l = m;
                    }
                }
                catch (NumberFormatException exception) {
                    l = seed.hashCode();
                }
            }
            boolean generateStructures = (generate_structures = (String)properties.get("generate-structures")) == null || Boolean.parseBoolean(generate_structures);
            MutableRegistry dimensionTypes = dynamicRegistries.func_243612_b(Registry.field_239698_ad_);
            MutableRegistry biomes = dynamicRegistries.func_243612_b(Registry.field_239720_u_);
            MutableRegistry chunkGeneratorSettings = dynamicRegistries.func_243612_b(Registry.field_243549_ar);
            SimpleRegistry dimensionOptions = DimensionType.func_242718_a((Registry)dimensionTypes, (Registry)biomes, (Registry)chunkGeneratorSettings, (long)l);
            prop = prop.substring(prop.indexOf(":") + 1);
            ConfigPack pack = TerraForgePlugin.getInstance().getConfigRegistry().get(prop);
            if (pack == null) {
                throw new IllegalArgumentException("No such pack " + prop);
            }
            TerraForgePlugin.getInstance().logger().info("Using config pack " + pack.getTemplate().getID());
            cir.setReturnValue((Object)new DimensionGeneratorSettings(l, generateStructures, false, DimensionGeneratorSettings.func_242749_a((Registry)dimensionTypes, (SimpleRegistry)dimensionOptions, (ChunkGenerator)new ForgeChunkGeneratorWrapper(new TerraBiomeSource((Registry<Biome>)biomes, l, pack), l, pack))));
        }
    }
}

