/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.registry;

import com.dfsek.tectonic.exception.LoadException;
import com.dfsek.tectonic.loading.ConfigLoader;
import com.dfsek.terra.api.registry.Registry;
import com.dfsek.terra.registry.exception.DuplicateEntryException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class OpenRegistry<T>
implements Registry<T> {
    private final Map<String, Entry<T>> objects = new HashMap<String, Entry<T>>();

    @Override
    public T load(Type type, Object o, ConfigLoader configLoader) throws LoadException {
        T obj = this.get((String)o);
        if (obj == null) {
            throw new LoadException("No such " + type.getTypeName() + " matching \"" + o + "\" was found in this registry.");
        }
        return obj;
    }

    public boolean add(String identifier, T value) {
        return this.add(identifier, new Entry<T>(value));
    }

    protected boolean add(String identifier, Entry<T> value) {
        boolean exists = this.objects.containsKey(identifier);
        this.objects.put(identifier, value);
        return exists;
    }

    public void addChecked(String identifier, T value) throws DuplicateEntryException {
        if (this.objects.containsKey(identifier)) {
            throw new DuplicateEntryException("Value with identifier \"" + identifier + "\" is already defined in registry.");
        }
        this.add(identifier, value);
    }

    @Override
    public boolean contains(String identifier) {
        return this.objects.containsKey(identifier);
    }

    @Override
    public T get(String identifier) {
        Entry<T> entry = this.objects.get(identifier);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public void forEach(Consumer<T> consumer) {
        this.objects.forEach((? super K id, ? super V obj) -> consumer.accept(((Entry)obj).getRaw()));
    }

    @Override
    public void forEach(BiConsumer<String, T> consumer) {
        this.objects.forEach((? super K id, ? super V entry) -> consumer.accept((String)id, (Object)((Entry)entry).getRaw()));
    }

    @Override
    public Set<T> entries() {
        return this.objects.values().stream().map(rec$ -> ((Entry)rec$).getRaw()).collect(Collectors.toSet());
    }

    @Override
    public Set<String> keys() {
        return this.objects.keySet();
    }

    public Map<String, T> getDeadEntries() {
        HashMap dead = new HashMap();
        this.objects.forEach((? super K id, ? super V entry) -> {
            if (entry.dead()) {
                dead.put(id, ((Entry)entry).value);
            }
        });
        return dead;
    }

    public void clear() {
        this.objects.clear();
    }

    protected static final class Entry<T> {
        private final T value;
        private final AtomicInteger access = new AtomicInteger(0);

        public Entry(T value) {
            this.value = value;
        }

        public T getValue() {
            this.access.incrementAndGet();
            return this.value;
        }

        private T getRaw() {
            return this.value;
        }

        public boolean dead() {
            return this.access.get() == 0;
        }
    }
}

