/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.registry.config;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.util.collections.MaterialSet;
import com.dfsek.terra.api.world.flora.Flora;
import com.dfsek.terra.registry.OpenRegistry;
import com.dfsek.terra.world.population.items.flora.ConstantFlora;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Callable;

public class FloraRegistry
extends OpenRegistry<Flora> {
    private final TerraPlugin main;

    public FloraRegistry(TerraPlugin main) {
        this.main = main;
        MaterialSet grassy = MaterialSet.get(this.create("minecraft:grass_block"), this.create("minecraft:podzol"));
        this.addItem("TALL_GRASS", () -> new ConstantFlora(grassy, Arrays.asList(this.data("minecraft:tall_grass[half=lower]"), this.data("minecraft:tall_grass[half=upper]"))));
        this.addItem("TALL_FERN", () -> new ConstantFlora(grassy, Arrays.asList(this.data("minecraft:large_fern[half=lower]"), this.data("minecraft:large_fern[half=upper]"))));
        this.addItem("SUNFLOWER", () -> new ConstantFlora(grassy, Arrays.asList(this.data("minecraft:sunflower[half=lower]"), this.data("minecraft:sunflower[half=upper]"))));
        this.addItem("ROSE_BUSH", () -> new ConstantFlora(grassy, Arrays.asList(this.data("minecraft:rose_bush[half=lower]"), this.data("minecraft:rose_bush[half=upper]"))));
        this.addItem("LILAC", () -> new ConstantFlora(grassy, Arrays.asList(this.data("minecraft:lilac[half=lower]"), this.data("minecraft:lilac[half=upper]"))));
        this.addItem("PEONY", () -> new ConstantFlora(grassy, Arrays.asList(this.data("minecraft:peony[half=lower]"), this.data("minecraft:peony[half=upper]"))));
        this.addItem("GRASS", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:grass"))));
        this.addItem("FERN", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:fern"))));
        this.addItem("AZURE_BLUET", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:azure_bluet"))));
        this.addItem("LILY_OF_THE_VALLEY", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:lily_of_the_valley"))));
        this.addItem("BLUE_ORCHID", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:blue_orchid"))));
        this.addItem("POPPY", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:poppy"))));
        this.addItem("DANDELION", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:dandelion"))));
        this.addItem("WITHER_ROSE", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:wither_rose"))));
        this.addItem("DEAD_BUSH", () -> new ConstantFlora(MaterialSet.get(this.create("minecraft:terracotta"), this.create("minecraft:black_terracotta"), this.create("minecraft:blue_terracotta"), this.create("minecraft:brown_terracotta"), this.create("minecraft:cyan_terracotta"), this.create("minecraft:gray_terracotta"), this.create("minecraft:green_terracotta"), this.create("minecraft:light_blue_terracotta"), this.create("minecraft:light_gray_terracotta"), this.create("minecraft:lime_terracotta"), this.create("minecraft:magenta_terracotta"), this.create("minecraft:orange_terracotta"), this.create("minecraft:pink_terracotta"), this.create("minecraft:purple_terracotta"), this.create("minecraft:red_terracotta"), this.create("minecraft:white_terracotta"), this.create("minecraft:yellow_terracotta"), this.create("minecraft:red_sand"), this.create("minecraft:sand"), this.create("minecraft:coarse_dirt")), Collections.singletonList(this.data("minecraft:dead_bush"))));
        this.addItem("RED_TULIP", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:red_tulip"))));
        this.addItem("ORANGE_TULIP", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:orange_tulip"))));
        this.addItem("WHITE_TULIP", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:white_tulip"))));
        this.addItem("PINK_TULIP", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:pink_tulip"))));
        this.addItem("OXEYE_DAISY", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:oxeye_daisy"))));
        this.addItem("ALLIUM", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:allium"))));
        this.addItem("CORNFLOWER", () -> new ConstantFlora(grassy, Collections.singletonList(this.data("minecraft:cornflower"))));
        this.addItem("LILY_PAD", () -> new ConstantFlora(MaterialSet.get(this.create("minecraft:water")), Collections.singletonList(this.data("minecraft:lily_pad"))));
        MaterialSet mushroom = MaterialSet.get(this.create("minecraft:grass_block"), this.create("minecraft:stone"), this.create("minecraft:podzol"), this.create("minecraft:netherrack"), this.create("minecraft:mycelium"));
        this.addItem("RED_MUSHROOM", () -> new ConstantFlora(mushroom, Collections.singletonList(this.data("minecraft:red_mushroom"))));
        this.addItem("BROWN_MUSHROOM", () -> new ConstantFlora(mushroom, Collections.singletonList(this.data("minecraft:brown_mushroom"))));
    }

    private BlockData create(String s) {
        return this.main.getWorldHandle().createBlockData(s);
    }

    private void addItem(String id, Callable<ConstantFlora> flora) {
        try {
            OpenRegistry.Entry<Flora> entry = new OpenRegistry.Entry<Flora>(flora.call());
            entry.getValue();
            this.add(id, entry);
        }
        catch (Exception e) {
            this.main.logger().warning("Failed to load Flora item: " + id + ": " + e.getMessage());
        }
    }

    private BlockData data(String s) {
        return this.main.getWorldHandle().createBlockData(s);
    }
}

