/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.registry.config;

import com.dfsek.tectonic.loading.object.ObjectTemplate;
import com.dfsek.terra.api.math.noise.samplers.noise.random.GaussianNoiseSampler;
import com.dfsek.terra.api.math.noise.samplers.noise.random.WhiteNoiseSampler;
import com.dfsek.terra.api.math.noise.samplers.noise.simplex.OpenSimplex2SSampler;
import com.dfsek.terra.api.math.noise.samplers.noise.simplex.OpenSimplex2Sampler;
import com.dfsek.terra.api.math.noise.samplers.noise.simplex.PerlinSampler;
import com.dfsek.terra.api.math.noise.samplers.noise.simplex.SimplexSampler;
import com.dfsek.terra.api.math.noise.samplers.noise.value.ValueCubicSampler;
import com.dfsek.terra.api.math.noise.samplers.noise.value.ValueSampler;
import com.dfsek.terra.api.util.seeded.NoiseSeeded;
import com.dfsek.terra.config.loaders.config.sampler.templates.DomainWarpTemplate;
import com.dfsek.terra.config.loaders.config.sampler.templates.ImageSamplerTemplate;
import com.dfsek.terra.config.loaders.config.sampler.templates.KernelTemplate;
import com.dfsek.terra.config.loaders.config.sampler.templates.noise.CellularNoiseTemplate;
import com.dfsek.terra.config.loaders.config.sampler.templates.noise.ConstantNoiseTemplate;
import com.dfsek.terra.config.loaders.config.sampler.templates.noise.ExpressionFunctionTemplate;
import com.dfsek.terra.config.loaders.config.sampler.templates.noise.GaborNoiseTemplate;
import com.dfsek.terra.config.loaders.config.sampler.templates.noise.SimpleNoiseTemplate;
import com.dfsek.terra.config.loaders.config.sampler.templates.noise.fractal.BrownianMotionTemplate;
import com.dfsek.terra.config.loaders.config.sampler.templates.noise.fractal.PingPongTemplate;
import com.dfsek.terra.config.loaders.config.sampler.templates.noise.fractal.RidgedFractalTemplate;
import com.dfsek.terra.config.loaders.config.sampler.templates.normalizer.ClampNormalizerTemplate;
import com.dfsek.terra.config.loaders.config.sampler.templates.normalizer.LinearNormalizerTemplate;
import com.dfsek.terra.config.loaders.config.sampler.templates.normalizer.NormalNormalizerTemplate;
import com.dfsek.terra.registry.OpenRegistry;
import java.util.function.Supplier;

public class NoiseRegistry
extends OpenRegistry<Supplier<ObjectTemplate<NoiseSeeded>>> {
    public NoiseRegistry() {
        this.add("LINEAR", LinearNormalizerTemplate::new);
        this.add("NORMAL", NormalNormalizerTemplate::new);
        this.add("CLAMP", ClampNormalizerTemplate::new);
        this.add("EXPRESSION", ExpressionFunctionTemplate::new);
        this.add("IMAGE", ImageSamplerTemplate::new);
        this.add("DOMAINWARP", DomainWarpTemplate::new);
        this.add("FBM", BrownianMotionTemplate::new);
        this.add("PINGPONG", PingPongTemplate::new);
        this.add("RIDGED", RidgedFractalTemplate::new);
        this.add("OPENSIMPLEX2", () -> new SimpleNoiseTemplate(OpenSimplex2Sampler::new));
        this.add("OPENSIMPLEX2S", () -> new SimpleNoiseTemplate(OpenSimplex2SSampler::new));
        this.add("PERLIN", () -> new SimpleNoiseTemplate(PerlinSampler::new));
        this.add("SIMPLEX", () -> new SimpleNoiseTemplate(SimplexSampler::new));
        this.add("GABOR", GaborNoiseTemplate::new);
        this.add("VALUE", () -> new SimpleNoiseTemplate(ValueSampler::new));
        this.add("VALUECUBIC", () -> new SimpleNoiseTemplate(ValueCubicSampler::new));
        this.add("CELLULAR", CellularNoiseTemplate::new);
        this.add("WHITENOISE", () -> new SimpleNoiseTemplate(WhiteNoiseSampler::new));
        this.add("GAUSSIAN", () -> new SimpleNoiseTemplate(GaussianNoiseSampler::new));
        this.add("CONSTANT", ConstantNoiseTemplate::new);
        this.add("KERNEL", KernelTemplate::new);
    }
}

